/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import org.apache.giraph.conf.EnumConfOption;
import org.apache.giraph.graph.GraphType;
import org.apache.hadoop.conf.Configuration;

public class PerGraphTypeEnumConfOption<T extends Enum<T>> {
    private final EnumConfOption<T> vertexId;
    private final EnumConfOption<T> vertexValue;
    private final EnumConfOption<T> edgeValue;
    private final EnumConfOption<T> incomingMessage;
    private final EnumConfOption<T> outgoingMessage;

    public PerGraphTypeEnumConfOption(String keyPrefix, Class<T> klass, T defaultValue, String description) {
        this.vertexId = EnumConfOption.create(keyPrefix + ".vertex.id", klass, defaultValue, description);
        this.vertexValue = EnumConfOption.create(keyPrefix + ".vertex.value", klass, defaultValue, description);
        this.edgeValue = EnumConfOption.create(keyPrefix + ".edge.value", klass, defaultValue, description);
        this.incomingMessage = EnumConfOption.create(keyPrefix + ".incoming.message", klass, defaultValue, description);
        this.outgoingMessage = EnumConfOption.create(keyPrefix + ".outgoing.message", klass, defaultValue, description);
    }

    public static <X extends Enum<X>> PerGraphTypeEnumConfOption<X> create(String keyPrefix, Class<X> klass, X defaultValue, String description) {
        return new PerGraphTypeEnumConfOption<X>(keyPrefix, klass, defaultValue, description);
    }

    public EnumConfOption<T> get(GraphType graphType) {
        switch (graphType) {
            case VERTEX_ID: {
                return this.vertexId;
            }
            case VERTEX_VALUE: {
                return this.vertexValue;
            }
            case EDGE_VALUE: {
                return this.edgeValue;
            }
            case INCOMING_MESSAGE_VALUE: {
                return this.incomingMessage;
            }
            case OUTGOING_MESSAGE_VALUE: {
                return this.outgoingMessage;
            }
        }
        throw new IllegalArgumentException("Don't know how to handle GraphType " + (Object)((Object)graphType));
    }

    public void set(Configuration conf, GraphType graphType, T language) {
        this.get(graphType).set(conf, (Enum<T>)language);
    }

    public EnumConfOption<T> getEdgeValue() {
        return this.edgeValue;
    }

    public EnumConfOption<T> getIncomingMessage() {
        return this.incomingMessage;
    }

    public EnumConfOption<T> getOutgoingMessage() {
        return this.outgoingMessage;
    }

    public EnumConfOption<T> getVertexId() {
        return this.vertexId;
    }

    public EnumConfOption<T> getVertexValue() {
        return this.vertexValue;
    }
}

