/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import org.apache.giraph.conf.EnumConfOption;
import org.apache.giraph.conf.PerGraphTypeEnumConfOption;
import org.apache.giraph.graph.GraphType;
import org.apache.hadoop.conf.Configuration;

public class PerGraphTypeEnum<T extends Enum<T>> {
    private T vertexId;
    private T vertexValue;
    private T edgeValue;
    private T incomingMessage;
    private T outgoingMessage;

    public static <T extends Enum<T>> PerGraphTypeEnum<T> readFromConf(PerGraphTypeEnumConfOption<T> options, Configuration conf) {
        PerGraphTypeEnum<T> pgte = new PerGraphTypeEnum<T>();
        pgte.setFrom(options, conf);
        return pgte;
    }

    public void setFrom(PerGraphTypeEnumConfOption<T> options, Configuration conf) {
        this.setVertexId(options.getVertexId(), conf);
        this.setVertexValue(options.getVertexValue(), conf);
        this.setEdgeValue(options.getEdgeValue(), conf);
        this.setIncomingMessage(options.getIncomingMessage(), conf);
        this.setOutgoingMessage(options.getOutgoingMessage(), conf);
    }

    public void setVertexId(EnumConfOption<T> option, Configuration conf) {
        this.vertexId = option.get(conf);
    }

    public void setVertexValue(EnumConfOption<T> option, Configuration conf) {
        this.vertexValue = option.get(conf);
    }

    public void setEdgeValue(EnumConfOption<T> option, Configuration conf) {
        this.edgeValue = option.get(conf);
    }

    public void setIncomingMessage(EnumConfOption<T> option, Configuration conf) {
        this.incomingMessage = option.get(conf);
    }

    public void setOutgoingMessage(EnumConfOption<T> option, Configuration conf) {
        this.outgoingMessage = option.get(conf);
    }

    public T get(GraphType graphType) {
        switch (graphType) {
            case VERTEX_ID: {
                return this.vertexId;
            }
            case VERTEX_VALUE: {
                return this.vertexValue;
            }
            case EDGE_VALUE: {
                return this.edgeValue;
            }
            case INCOMING_MESSAGE_VALUE: {
                return this.incomingMessage;
            }
            case OUTGOING_MESSAGE_VALUE: {
                return this.outgoingMessage;
            }
        }
        throw new IllegalArgumentException("Don't know how to handle GraphType " + (Object)((Object)graphType));
    }

    public T getEdgeValue() {
        return this.edgeValue;
    }

    public T getIncomingMessage() {
        return this.incomingMessage;
    }

    public T getOutgoingMessage() {
        return this.outgoingMessage;
    }

    public T getVertexId() {
        return this.vertexId;
    }

    public T getVertexValue() {
        return this.vertexValue;
    }
}

