/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import org.apache.giraph.conf.BooleanConfOption;
import org.apache.giraph.graph.GraphType;
import org.apache.hadoop.conf.Configuration;

public class PerGraphTypeBooleanConfOption {
    private final BooleanConfOption vertexId;
    private final BooleanConfOption vertexValue;
    private final BooleanConfOption edgeValue;
    private final BooleanConfOption incomingMessage;
    private final BooleanConfOption outgoingMessage;

    public PerGraphTypeBooleanConfOption(String keyPrefix, boolean defaultValue, String description) {
        this.vertexId = new BooleanConfOption(keyPrefix + ".vertex.id", defaultValue, description);
        this.vertexValue = new BooleanConfOption(keyPrefix + ".vertex.value", defaultValue, description);
        this.edgeValue = new BooleanConfOption(keyPrefix + ".edge.value", defaultValue, description);
        this.incomingMessage = new BooleanConfOption(keyPrefix + ".incoming.message", defaultValue, description);
        this.outgoingMessage = new BooleanConfOption(keyPrefix + ".outgoing.message", defaultValue, description);
    }

    public BooleanConfOption get(GraphType graphType) {
        switch (graphType) {
            case VERTEX_ID: {
                return this.vertexId;
            }
            case VERTEX_VALUE: {
                return this.vertexValue;
            }
            case EDGE_VALUE: {
                return this.edgeValue;
            }
            case INCOMING_MESSAGE_VALUE: {
                return this.incomingMessage;
            }
            case OUTGOING_MESSAGE_VALUE: {
                return this.outgoingMessage;
            }
        }
        throw new IllegalArgumentException("Don't know how to handle GraphType " + (Object)((Object)graphType));
    }

    public void set(Configuration conf, GraphType graphType, boolean value) {
        this.get(graphType).set(conf, value);
    }

    public BooleanConfOption getEdgeValue() {
        return this.edgeValue;
    }

    public BooleanConfOption getIncomingMessage() {
        return this.incomingMessage;
    }

    public BooleanConfOption getOutgoingMessage() {
        return this.outgoingMessage;
    }

    public BooleanConfOption getVertexId() {
        return this.vertexId;
    }

    public BooleanConfOption getVertexValue() {
        return this.vertexValue;
    }
}

