/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import org.apache.giraph.conf.BooleanConfOption;
import org.apache.giraph.conf.PerGraphTypeBooleanConfOption;
import org.apache.giraph.graph.GraphType;
import org.apache.hadoop.conf.Configuration;

public class PerGraphTypeBoolean {
    private boolean vertexId;
    private boolean vertexValue;
    private boolean edgeValue;
    private boolean incomingMessage;
    private boolean outgoingMessage;

    public static PerGraphTypeBoolean readFromConf(PerGraphTypeBooleanConfOption options, Configuration conf) {
        PerGraphTypeBoolean pgtb = new PerGraphTypeBoolean();
        pgtb.setFrom(options, conf);
        return pgtb;
    }

    public void setFrom(PerGraphTypeBooleanConfOption options, Configuration conf) {
        this.setVertexId(options.getVertexId(), conf);
        this.setVertexValue(options.getVertexValue(), conf);
        this.setEdgeValue(options.getEdgeValue(), conf);
        this.setIncomingMessage(options.getIncomingMessage(), conf);
        this.setOutgoingMessage(options.getOutgoingMessage(), conf);
    }

    public void setVertexId(BooleanConfOption option, Configuration conf) {
        this.vertexId = option.get(conf);
    }

    public void setVertexValue(BooleanConfOption option, Configuration conf) {
        this.vertexValue = option.get(conf);
    }

    public void setEdgeValue(BooleanConfOption option, Configuration conf) {
        this.edgeValue = option.get(conf);
    }

    public void setIncomingMessage(BooleanConfOption option, Configuration conf) {
        this.incomingMessage = option.get(conf);
    }

    public void setOutgoingMessage(BooleanConfOption option, Configuration conf) {
        this.outgoingMessage = option.get(conf);
    }

    public boolean get(GraphType graphType) {
        switch (graphType) {
            case VERTEX_ID: {
                return this.vertexId;
            }
            case VERTEX_VALUE: {
                return this.vertexValue;
            }
            case EDGE_VALUE: {
                return this.edgeValue;
            }
            case INCOMING_MESSAGE_VALUE: {
                return this.incomingMessage;
            }
            case OUTGOING_MESSAGE_VALUE: {
                return this.outgoingMessage;
            }
        }
        throw new IllegalArgumentException("Don't know how to handle GraphType " + (Object)((Object)graphType));
    }

    public boolean getEdgeValue() {
        return this.edgeValue;
    }

    public boolean getIncomingMessage() {
        return this.incomingMessage;
    }

    public boolean getOutgoingMessage() {
        return this.outgoingMessage;
    }

    public boolean getVertexId() {
        return this.vertexId;
    }

    public boolean getVertexValue() {
        return this.vertexValue;
    }
}

