/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import org.apache.giraph.conf.AbstractConfOption;
import org.apache.giraph.conf.AllOptions;
import org.apache.giraph.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;

public class LongConfOption
extends AbstractConfOption {
    private long defaultValue;

    public LongConfOption(String key, long defaultValue, String description) {
        super(key, description);
        this.defaultValue = defaultValue;
        AllOptions.add(this);
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isDefaultValue(Configuration conf) {
        return this.get(conf) == this.defaultValue;
    }

    @Override
    public String getDefaultValueStr() {
        return Long.toString(this.defaultValue);
    }

    @Override
    public ConfOptionType getType() {
        return ConfOptionType.LONG;
    }

    public long get(Configuration conf) {
        return conf.getLong(this.getKey(), this.defaultValue);
    }

    public long getWithDefault(Configuration conf, long val) {
        return conf.getLong(this.getKey(), val);
    }

    public void set(Configuration conf, long value) {
        conf.setLong(this.getKey(), value);
    }

    public void setIfUnset(Configuration conf, long value) {
        if (!this.contains(conf)) {
            conf.setLong(this.getKey(), value);
        }
    }
}

