/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import java.io.IOException;
import org.apache.giraph.conf.AbstractConfOption;
import org.apache.giraph.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class JsonStringConfOption
extends AbstractConfOption {
    private static final Logger LOG = Logger.getLogger(JsonStringConfOption.class);

    public JsonStringConfOption(String key, String description) {
        super(key, description);
    }

    public void set(Configuration conf, Object value) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            String jsonStr = mapper.writeValueAsString(value);
            conf.set(this.getKey(), jsonStr);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to set " + this.getKey() + " with json value from " + value);
        }
    }

    public String getRaw(Configuration conf) {
        return conf.get(this.getKey());
    }

    public <T> T get(Configuration conf, Class<T> klass) {
        String jsonStr = this.getRaw(conf);
        Object value = null;
        if (jsonStr != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                value = mapper.readValue(jsonStr, klass);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read json from key " + this.getKey() + " with class " + klass);
            }
        }
        return (T)value;
    }

    public <T> T get(Configuration conf, TypeReference<T> typeReference) {
        String jsonStr = this.getRaw(conf);
        Object value = null;
        if (jsonStr != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                value = mapper.readValue(jsonStr, typeReference);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read json from key " + this.getKey() + " with class " + typeReference);
            }
        }
        return (T)value;
    }

    public <T> T getWithDefault(Configuration conf, Class<T> klass, T defaultValue) {
        if (this.contains(conf)) {
            return this.get(conf, klass);
        }
        return defaultValue;
    }

    @Override
    public String getDefaultValueStr() {
        return "null";
    }

    @Override
    public boolean isDefaultValue(Configuration conf) {
        return !this.contains(conf);
    }

    @Override
    public ConfOptionType getType() {
        return ConfOptionType.STRING;
    }
}

