/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import org.apache.giraph.conf.AbstractConfOption;
import org.apache.giraph.conf.AllOptions;
import org.apache.giraph.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;

public class IntConfOption
extends AbstractConfOption {
    private final int defaultValue;

    public IntConfOption(String key, int defaultValue, String description) {
        super(key, description);
        this.defaultValue = defaultValue;
        AllOptions.add(this);
    }

    public IntConfOption(String key, long defaultValue, String description) {
        super(key, description);
        this.defaultValue = (int)defaultValue;
        AllOptions.add(this);
    }

    public int getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isDefaultValue(Configuration conf) {
        return this.get(conf) == this.defaultValue;
    }

    @Override
    public String getDefaultValueStr() {
        return Integer.toString(this.defaultValue);
    }

    @Override
    public ConfOptionType getType() {
        return ConfOptionType.INTEGER;
    }

    public int get(Configuration conf) {
        return conf.getInt(this.getKey(), this.defaultValue);
    }

    public void set(Configuration conf, int value) {
        conf.setInt(this.getKey(), value);
    }

    public void setIfUnset(Configuration conf, int value) {
        if (!this.contains(conf)) {
            conf.setInt(this.getKey(), value);
        }
    }
}

