/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import com.google.common.base.Preconditions;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.compression.JdkZlibDecoder;
import io.netty.handler.codec.compression.JdkZlibEncoder;
import io.netty.handler.codec.compression.SnappyFramedDecoder;
import io.netty.handler.codec.compression.SnappyFramedEncoder;
import org.apache.giraph.aggregators.AggregatorWriter;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.conf.GiraphClasses;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConfigurationSettable;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.GiraphTypes;
import org.apache.giraph.conf.PerGraphTypeBoolean;
import org.apache.giraph.conf.PerGraphTypeEnum;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.EdgeStoreFactory;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.edge.ReusableEdge;
import org.apache.giraph.factories.ComputationFactory;
import org.apache.giraph.factories.EdgeValueFactory;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.factories.ValueFactories;
import org.apache.giraph.factories.VertexIdFactory;
import org.apache.giraph.factories.VertexValueFactory;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.Language;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexResolver;
import org.apache.giraph.graph.VertexValueCombiner;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeOutputFormat;
import org.apache.giraph.io.MappingInputFormat;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.filters.EdgeInputFilter;
import org.apache.giraph.io.filters.VertexInputFilter;
import org.apache.giraph.io.internal.WrappedEdgeInputFormat;
import org.apache.giraph.io.internal.WrappedEdgeOutputFormat;
import org.apache.giraph.io.internal.WrappedMappingInputFormat;
import org.apache.giraph.io.internal.WrappedVertexInputFormat;
import org.apache.giraph.io.internal.WrappedVertexOutputFormat;
import org.apache.giraph.io.superstep_output.MultiThreadedSuperstepOutput;
import org.apache.giraph.io.superstep_output.NoOpSuperstepOutput;
import org.apache.giraph.io.superstep_output.SuperstepOutput;
import org.apache.giraph.io.superstep_output.SynchronizedSuperstepOutput;
import org.apache.giraph.job.GiraphJobObserver;
import org.apache.giraph.job.GiraphJobRetryChecker;
import org.apache.giraph.mapping.MappingStore;
import org.apache.giraph.mapping.MappingStoreOps;
import org.apache.giraph.mapping.translate.TranslateEdge;
import org.apache.giraph.master.MasterCompute;
import org.apache.giraph.master.MasterObserver;
import org.apache.giraph.master.SuperstepClasses;
import org.apache.giraph.partition.GraphPartitionerFactory;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.utils.ExtendedByteArrayDataInput;
import org.apache.giraph.utils.ExtendedByteArrayDataOutput;
import org.apache.giraph.utils.ExtendedDataInput;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.giraph.utils.UnsafeByteArrayInputStream;
import org.apache.giraph.utils.UnsafeByteArrayOutputStream;
import org.apache.giraph.utils.WritableUtils;
import org.apache.giraph.utils.io.BigDataInputOutput;
import org.apache.giraph.utils.io.DataInputOutput;
import org.apache.giraph.utils.io.ExtendedDataInputOutput;
import org.apache.giraph.worker.WorkerContext;
import org.apache.giraph.worker.WorkerObserver;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;

public class ImmutableClassesGiraphConfiguration<I extends WritableComparable, V extends Writable, E extends Writable>
extends GiraphConfiguration {
    private final GiraphClasses classes;
    private Class<? extends Writable> mappingTargetClass = null;
    private final ValueFactories<I, V, E> valueFactories;
    private final PerGraphTypeEnum<Language> valueLanguages;
    private final PerGraphTypeBoolean valueNeedsWrappers;
    private final boolean useUnsafeSerialization;
    private final boolean useBigDataIOForMessages;

    public ImmutableClassesGiraphConfiguration(Configuration conf) {
        super(conf);
        this.classes = new GiraphClasses(conf);
        this.useUnsafeSerialization = USE_UNSAFE_SERIALIZATION.get(this);
        this.useBigDataIOForMessages = USE_BIG_DATA_IO_FOR_MESSAGES.get(this);
        this.valueLanguages = PerGraphTypeEnum.readFromConf(GiraphConstants.GRAPH_TYPE_LANGUAGES, conf);
        this.valueNeedsWrappers = PerGraphTypeBoolean.readFromConf(GiraphConstants.GRAPH_TYPES_NEEDS_WRAPPERS, conf);
        this.valueFactories = new ValueFactories(conf);
        this.valueFactories.initializeIVE(this);
    }

    public void configureIfPossible(Object obj) {
        if (obj instanceof GiraphConfigurationSettable) {
            ((GiraphConfigurationSettable)obj).setConf(this);
        }
    }

    public PerGraphTypeBoolean getValueNeedsWrappers() {
        return this.valueNeedsWrappers;
    }

    public PerGraphTypeEnum<Language> getValueLanguages() {
        return this.valueLanguages;
    }

    public Class<? extends TranslateEdge> edgeTranslationClass() {
        return EDGE_TRANSLATION_CLASS.get(this);
    }

    public TranslateEdge<I, E> edgeTranslationInstance() {
        if (this.edgeTranslationClass() != null) {
            return ReflectionUtils.newInstance(this.edgeTranslationClass(), this);
        }
        return null;
    }

    public Class<? extends EdgeInputFilter<I, E>> getEdgeInputFilterClass() {
        return this.classes.getEdgeInputFilterClass();
    }

    public EdgeInputFilter getEdgeInputFilter() {
        return ReflectionUtils.newInstance(this.getEdgeInputFilterClass(), this);
    }

    public Class<? extends VertexInputFilter<I, V, E>> getVertexInputFilterClass() {
        return this.classes.getVertexInputFilterClass();
    }

    public VertexInputFilter getVertexInputFilter() {
        return ReflectionUtils.newInstance(this.getVertexInputFilterClass(), this);
    }

    public Class<? extends GraphPartitionerFactory<I, V, E>> getGraphPartitionerClass() {
        return this.classes.getGraphPartitionerFactoryClass();
    }

    public GraphPartitionerFactory<I, V, E> createGraphPartitioner() {
        Class klass = this.classes.getGraphPartitionerFactoryClass();
        return ReflectionUtils.newInstance(klass, this);
    }

    @Override
    public boolean hasVertexInputFormat() {
        return this.classes.hasVertexInputFormat();
    }

    public Class<? extends VertexInputFormat<I, V, E>> getVertexInputFormatClass() {
        return this.classes.getVertexInputFormatClass();
    }

    private VertexInputFormat<I, V, E> createVertexInputFormat() {
        Class<VertexInputFormat<I, V, E>> klass = this.getVertexInputFormatClass();
        return ReflectionUtils.newInstance(klass, this);
    }

    public WrappedVertexInputFormat<I, V, E> createWrappedVertexInputFormat() {
        WrappedVertexInputFormat<I, V, E> wrappedVertexInputFormat = new WrappedVertexInputFormat<I, V, E>(this.createVertexInputFormat());
        this.configureIfPossible(wrappedVertexInputFormat);
        return wrappedVertexInputFormat;
    }

    @Override
    public void setVertexInputFormatClass(Class<? extends VertexInputFormat> vertexInputFormatClass) {
        super.setVertexInputFormatClass(vertexInputFormatClass);
        this.classes.setVertexInputFormatClass(vertexInputFormatClass);
    }

    @Override
    public boolean hasVertexOutputFormat() {
        return this.classes.hasVertexOutputFormat();
    }

    public Class<? extends VertexOutputFormat<I, V, E>> getVertexOutputFormatClass() {
        return this.classes.getVertexOutputFormatClass();
    }

    public Class<? extends MappingInputFormat<I, V, E, ? extends Writable>> getMappingInputFormatClass() {
        return this.classes.getMappingInputFormatClass();
    }

    public boolean hasMappingInputFormat() {
        return this.classes.hasMappingInputFormat();
    }

    private VertexOutputFormat<I, V, E> createVertexOutputFormat() {
        Class<VertexOutputFormat<I, V, E>> klass = this.getVertexOutputFormatClass();
        return ReflectionUtils.newInstance(klass, this);
    }

    private MappingInputFormat<I, V, E, ? extends Writable> createMappingInputFormat() {
        Class<MappingInputFormat<I, V, E, Writable>> klass = this.getMappingInputFormatClass();
        return ReflectionUtils.newInstance(klass, this);
    }

    public WrappedVertexOutputFormat<I, V, E> createWrappedVertexOutputFormat() {
        WrappedVertexOutputFormat<I, V, E> wrappedVertexOutputFormat = new WrappedVertexOutputFormat<I, V, E>(this.createVertexOutputFormat());
        this.configureIfPossible(wrappedVertexOutputFormat);
        return wrappedVertexOutputFormat;
    }

    public WrappedMappingInputFormat<I, V, E, ? extends Writable> createWrappedMappingInputFormat() {
        WrappedMappingInputFormat<I, V, E, Writable> wrappedMappingInputFormat = new WrappedMappingInputFormat<I, V, E, Writable>(this.createMappingInputFormat());
        this.configureIfPossible(wrappedMappingInputFormat);
        return wrappedMappingInputFormat;
    }

    @Override
    public boolean hasEdgeOutputFormat() {
        return this.classes.hasEdgeOutputFormat();
    }

    public Class<? extends EdgeOutputFormat<I, V, E>> getEdgeOutputFormatClass() {
        return this.classes.getEdgeOutputFormatClass();
    }

    private EdgeOutputFormat<I, V, E> createEdgeOutputFormat() {
        Class<EdgeOutputFormat<I, V, E>> klass = this.getEdgeOutputFormatClass();
        return ReflectionUtils.newInstance(klass, this);
    }

    public WrappedEdgeOutputFormat<I, V, E> createWrappedEdgeOutputFormat() {
        WrappedEdgeOutputFormat<I, V, E> wrappedEdgeOutputFormat = new WrappedEdgeOutputFormat<I, V, E>(this.createEdgeOutputFormat());
        this.configureIfPossible(wrappedEdgeOutputFormat);
        return wrappedEdgeOutputFormat;
    }

    public SuperstepOutput<I, V, E> createSuperstepOutput(Mapper.Context context) {
        if (this.doOutputDuringComputation()) {
            if (this.vertexOutputFormatThreadSafe()) {
                return new MultiThreadedSuperstepOutput(this, context);
            }
            return new SynchronizedSuperstepOutput(this, context);
        }
        return new NoOpSuperstepOutput();
    }

    @Override
    public boolean hasEdgeInputFormat() {
        return this.classes.hasEdgeInputFormat();
    }

    public Class<? extends EdgeInputFormat<I, E>> getEdgeInputFormatClass() {
        return this.classes.getEdgeInputFormatClass();
    }

    private EdgeInputFormat<I, E> createEdgeInputFormat() {
        Class<EdgeInputFormat<I, E>> klass = this.getEdgeInputFormatClass();
        return ReflectionUtils.newInstance(klass, this);
    }

    public WrappedEdgeInputFormat<I, E> createWrappedEdgeInputFormat() {
        WrappedEdgeInputFormat<I, E> wrappedEdgeInputFormat = new WrappedEdgeInputFormat<I, E>(this.createEdgeInputFormat());
        this.configureIfPossible(wrappedEdgeInputFormat);
        return wrappedEdgeInputFormat;
    }

    @Override
    public void setEdgeInputFormatClass(Class<? extends EdgeInputFormat> edgeInputFormatClass) {
        super.setEdgeInputFormatClass(edgeInputFormatClass);
        this.classes.setEdgeInputFormatClass(edgeInputFormatClass);
    }

    public Class<? extends AggregatorWriter> getAggregatorWriterClass() {
        return this.classes.getAggregatorWriterClass();
    }

    public AggregatorWriter createAggregatorWriter() {
        return ReflectionUtils.newInstance(this.getAggregatorWriterClass(), this);
    }

    public Class<? extends MessageCombiner<I, ? extends Writable>> getMessageCombinerClass() {
        return this.classes.getMessageCombinerClass();
    }

    public <M extends Writable> MessageCombiner<I, M> createMessageCombiner() {
        Class klass = this.classes.getMessageCombinerClass();
        return ReflectionUtils.newInstance(klass, this);
    }

    public boolean useMessageCombiner() {
        return this.classes.hasMessageCombinerClass();
    }

    public Class<? extends VertexValueCombiner<V>> getVertexValueCombinerClass() {
        return this.classes.getVertexValueCombinerClass();
    }

    public VertexValueCombiner<V> createVertexValueCombiner() {
        return ReflectionUtils.newInstance(this.getVertexValueCombinerClass(), this);
    }

    public Class<? extends VertexResolver<I, V, E>> getVertexResolverClass() {
        return this.classes.getVertexResolverClass();
    }

    public VertexResolver<I, V, E> createVertexResolver() {
        return ReflectionUtils.newInstance(this.getVertexResolverClass(), this);
    }

    public Class<? extends WorkerContext> getWorkerContextClass() {
        return this.classes.getWorkerContextClass();
    }

    public WorkerContext createWorkerContext() {
        return ReflectionUtils.newInstance(this.getWorkerContextClass(), this);
    }

    public Class<? extends MasterCompute> getMasterComputeClass() {
        return this.classes.getMasterComputeClass();
    }

    public MasterCompute createMasterCompute() {
        return ReflectionUtils.newInstance(this.getMasterComputeClass(), this);
    }

    public Class<? extends Computation<I, V, E, ? extends Writable, ? extends Writable>> getComputationClass() {
        return this.classes.getComputationClass();
    }

    public Class<? extends ComputationFactory<I, V, E, ? extends Writable, ? extends Writable>> getComputationFactoryClass() {
        return this.classes.getComputationFactoryClass();
    }

    public ComputationFactory<I, V, E, ? extends Writable, ? extends Writable> createComputationFactory() {
        return ReflectionUtils.newInstance(this.getComputationFactoryClass(), this);
    }

    public Computation<I, V, E, ? extends Writable, ? extends Writable> createComputation() {
        return this.createComputationFactory().createComputation(this);
    }

    public GiraphTypes<I, V, E> getGiraphTypes() {
        return this.classes.getGiraphTypes();
    }

    public Vertex<I, V, E> createVertex() {
        Class<Vertex> vertexClass = this.classes.getVertexClass();
        return ReflectionUtils.newInstance(vertexClass, this);
    }

    public Class<I> getVertexIdClass() {
        return this.classes.getVertexIdClass();
    }

    public VertexIdFactory<I> getVertexIdFactory() {
        return this.valueFactories.getVertexIdFactory();
    }

    public I createVertexId() {
        return (I)((WritableComparable)this.getVertexIdFactory().newInstance());
    }

    public Class<V> getVertexValueClass() {
        return this.classes.getVertexValueClass();
    }

    public VertexValueFactory<V> getVertexValueFactory() {
        return this.valueFactories.getVertexValueFactory();
    }

    public V createVertexValue() {
        return (V)this.getVertexValueFactory().newInstance();
    }

    public Class<? extends VertexValueFactory<V>> getVertexValueFactoryClass() {
        return this.valueFactories.getVertexValueFactory().getClass();
    }

    public MasterObserver[] createMasterObservers() {
        Class<? extends MasterObserver>[] klasses = this.getMasterObserverClasses();
        MasterObserver[] objects = new MasterObserver[klasses.length];
        for (int i = 0; i < klasses.length; ++i) {
            objects[i] = ReflectionUtils.newInstance(klasses[i], this);
        }
        return objects;
    }

    public WorkerObserver[] createWorkerObservers() {
        Class<? extends WorkerObserver>[] klasses = this.getWorkerObserverClasses();
        WorkerObserver[] objects = new WorkerObserver[klasses.length];
        for (int i = 0; i < klasses.length; ++i) {
            objects[i] = ReflectionUtils.newInstance(klasses[i], this);
        }
        return objects;
    }

    public GiraphJobObserver getJobObserver() {
        return ReflectionUtils.newInstance(this.getJobObserverClass(), this);
    }

    public GiraphJobRetryChecker getJobRetryChecker() {
        return ReflectionUtils.newInstance(this.getJobRetryCheckerClass(), this);
    }

    public Class<E> getEdgeValueClass() {
        return this.classes.getEdgeValueClass();
    }

    public boolean isEdgeValueNullWritable() {
        return this.getEdgeValueClass() == NullWritable.class;
    }

    public EdgeValueFactory<E> getEdgeValueFactory() {
        return this.valueFactories.getEdgeValueFactory();
    }

    public E createEdgeValue() {
        return (E)this.getEdgeValueFactory().newInstance();
    }

    public Edge<I, E> createEdge() {
        if (this.isEdgeValueNullWritable()) {
            return EdgeFactory.create(this.createVertexId());
        }
        return EdgeFactory.create(this.createVertexId(), this.createEdgeValue());
    }

    public Edge<I, E> createEdge(TranslateEdge<I, E> translateEdge, Edge<I, E> edge) {
        I translatedId = translateEdge.translateId(edge.getTargetVertexId());
        if (this.isEdgeValueNullWritable()) {
            return EdgeFactory.create(translatedId);
        }
        return EdgeFactory.create(translatedId, translateEdge.cloneValue(edge.getValue()));
    }

    public ReusableEdge<I, E> createReusableEdge() {
        if (this.isEdgeValueNullWritable()) {
            return EdgeFactory.createReusable(this.createVertexId());
        }
        return EdgeFactory.createReusable(this.createVertexId(), this.createEdgeValue());
    }

    public EdgeStoreFactory<I, V, E> createEdgeStoreFactory() {
        Class edgeStoreFactoryClass = EDGE_STORE_FACTORY_CLASS.get(this);
        return (EdgeStoreFactory)ReflectionUtils.newInstance(edgeStoreFactoryClass);
    }

    public <M extends Writable> Class<M> getIncomingMessageValueClass() {
        return this.classes.getIncomingMessageValueClass();
    }

    public <M extends Writable> MessageValueFactory<M> getIncomingMessageValueFactory() {
        Class<MessageValueFactory> klass = this.valueFactories.getInMsgFactoryClass();
        MessageValueFactory factory = ReflectionUtils.newInstance(klass, this);
        factory.initialize(this);
        return factory;
    }

    public <M extends Writable> Class<M> getOutgoingMessageValueClass() {
        return this.classes.getOutgoingMessageValueClass();
    }

    public <M extends Writable> MessageValueFactory<M> getOutgoingMessageValueFactory() {
        Class<MessageValueFactory> klass = this.valueFactories.getOutMsgFactoryClass();
        MessageValueFactory factory = ReflectionUtils.newInstance(klass, this);
        factory.initialize(this);
        return factory;
    }

    public Class<? extends OutEdges<I, E>> getOutEdgesClass() {
        return this.classes.getOutEdgesClass();
    }

    public Class<? extends OutEdges<I, E>> getInputOutEdgesClass() {
        return this.classes.getInputOutEdgesClass();
    }

    public boolean useInputOutEdges() {
        return this.classes.getInputOutEdgesClass() != this.classes.getOutEdgesClass();
    }

    public Class<? extends MappingStore> getMappingStoreClass() {
        return MAPPING_STORE_CLASS.get(this);
    }

    public MappingStore<I, ? extends Writable> createMappingStore() {
        if (this.getMappingStoreClass() != null) {
            return ReflectionUtils.newInstance(this.getMappingStoreClass(), this);
        }
        return null;
    }

    public Class<? extends MappingStoreOps> getMappingStoreOpsClass() {
        return MAPPING_STORE_OPS_CLASS.get(this);
    }

    public MappingStoreOps<I, ? extends Writable> createMappingStoreOps() {
        if (this.getMappingStoreOpsClass() != null) {
            return ReflectionUtils.newInstance(this.getMappingStoreOpsClass(), this);
        }
        return null;
    }

    public Class<? extends Writable> getMappingTargetClass() {
        if (this.mappingTargetClass == null) {
            Class<?>[] classList = ReflectionUtils.getTypeArguments(MappingStore.class, this.getMappingStoreClass());
            Preconditions.checkArgument((classList.length == 2 ? 1 : 0) != 0);
            this.mappingTargetClass = classList[1];
        }
        return this.mappingTargetClass;
    }

    public Writable createMappingTarget() {
        return WritableUtils.createWritable(this.getMappingTargetClass());
    }

    public OutEdges<I, E> createOutEdges() {
        return ReflectionUtils.newInstance(this.getOutEdgesClass(), this);
    }

    public OutEdges<I, E> createAndInitializeOutEdges() {
        OutEdges<I, E> outEdges = this.createOutEdges();
        outEdges.initialize();
        return outEdges;
    }

    public OutEdges<I, E> createAndInitializeOutEdges(int capacity) {
        OutEdges<I, E> outEdges = this.createOutEdges();
        outEdges.initialize(capacity);
        return outEdges;
    }

    public OutEdges<I, E> createAndInitializeOutEdges(Iterable<Edge<I, E>> edges) {
        OutEdges<I, E> outEdges = this.createOutEdges();
        outEdges.initialize(edges);
        return outEdges;
    }

    public OutEdges<I, E> createInputOutEdges() {
        return ReflectionUtils.newInstance(this.getInputOutEdgesClass(), this);
    }

    public OutEdges<I, E> createAndInitializeInputOutEdges() {
        OutEdges<I, E> outEdges = this.createInputOutEdges();
        outEdges.initialize();
        return outEdges;
    }

    public Partition<I, V, E> createPartition(int id, Progressable progressable) {
        Class klass = this.classes.getPartitionClass();
        Partition partition = ReflectionUtils.newInstance(klass, this);
        partition.initialize(id, progressable);
        return partition;
    }

    public boolean useUnsafeSerialization() {
        return this.useUnsafeSerialization;
    }

    public DataInputOutput createMessagesInputOutput() {
        if (this.useBigDataIOForMessages) {
            return new BigDataInputOutput(this);
        }
        return new ExtendedDataInputOutput(this);
    }

    public ExtendedDataOutput createExtendedDataOutput() {
        if (this.useUnsafeSerialization) {
            return new UnsafeByteArrayOutputStream();
        }
        return new ExtendedByteArrayDataOutput();
    }

    public ExtendedDataOutput createExtendedDataOutput(int expectedSize) {
        if (this.useUnsafeSerialization) {
            return new UnsafeByteArrayOutputStream(expectedSize);
        }
        return new ExtendedByteArrayDataOutput(expectedSize);
    }

    public ExtendedDataOutput createExtendedDataOutput(byte[] buf, int pos) {
        if (this.useUnsafeSerialization) {
            return new UnsafeByteArrayOutputStream(buf, pos);
        }
        return new ExtendedByteArrayDataOutput(buf, pos);
    }

    public ExtendedDataInput createExtendedDataInput(byte[] buf, int off, int length) {
        if (this.useUnsafeSerialization) {
            return new UnsafeByteArrayInputStream(buf, off, length);
        }
        return new ExtendedByteArrayDataInput(buf, off, length);
    }

    public ExtendedDataInput createExtendedDataInput(ExtendedDataOutput extendedDataOutput) {
        return this.createExtendedDataInput(extendedDataOutput.getByteArray(), 0, extendedDataOutput.getPos());
    }

    public void updateSuperstepClasses(SuperstepClasses superstepClasses) {
        Class<? extends Writable> outgoingMsgValueClass;
        Class<? extends Computation> computationClass = superstepClasses.getComputationClass();
        this.classes.setComputationClass(computationClass);
        Class<? extends Writable> incomingMsgValueClass = superstepClasses.getIncomingMessageClass();
        if (incomingMsgValueClass != null) {
            this.classes.setIncomingMessageValueClass(incomingMsgValueClass);
        }
        if ((outgoingMsgValueClass = superstepClasses.getOutgoingMessageClass()) != null) {
            this.classes.setOutgoingMessageValueClass(outgoingMsgValueClass);
        }
        this.classes.setMessageCombiner(superstepClasses.getMessageCombinerClass());
    }

    public boolean doCompression() {
        switch (GiraphConstants.NETTY_COMPRESSION_ALGORITHM.get(this)) {
            case "SNAPPY": {
                return true;
            }
            case "INFLATE": {
                return true;
            }
        }
        return false;
    }

    public MessageToByteEncoder getNettyCompressionEncoder() {
        switch (GiraphConstants.NETTY_COMPRESSION_ALGORITHM.get(this)) {
            case "SNAPPY": {
                return new SnappyFramedEncoder();
            }
            case "INFLATE": {
                return new JdkZlibEncoder();
            }
        }
        return null;
    }

    public ByteToMessageDecoder getNettyCompressionDecoder() {
        switch (GiraphConstants.NETTY_COMPRESSION_ALGORITHM.get(this)) {
            case "SNAPPY": {
                return new SnappyFramedDecoder(true);
            }
            case "INFLATE": {
                return new JdkZlibDecoder();
            }
        }
        return null;
    }
}

