/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import com.google.common.base.Preconditions;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.TypesHolder;
import org.apache.giraph.graph.DefaultVertex;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.utils.ConfigurationUtils;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class GiraphTypes<I extends WritableComparable, V extends Writable, E extends Writable> {
    private Class<I> vertexIdClass;
    private Class<V> vertexValueClass;
    private Class<E> edgeValueClass;
    private Class<? extends Writable> incomingMessageValueClass;
    private Class<? extends Writable> outgoingMessageValueClass;
    private Class<? extends Vertex> vertexClass = DefaultVertex.class;

    public GiraphTypes() {
    }

    public GiraphTypes(Class<I> vertexIdClass, Class<V> vertexValueClass, Class<E> edgeValueClass, Class<? extends Writable> incomingMessageValueClass, Class<? extends Writable> outgoingMessageValueClass) {
        this.edgeValueClass = edgeValueClass;
        this.incomingMessageValueClass = incomingMessageValueClass;
        this.outgoingMessageValueClass = outgoingMessageValueClass;
        this.vertexIdClass = vertexIdClass;
        this.vertexValueClass = vertexValueClass;
    }

    public static <IX extends WritableComparable, VX extends Writable, EX extends Writable> GiraphTypes<IX, VX, EX> readFrom(Configuration conf) {
        Class<? extends TypesHolder> klass;
        GiraphTypes types = new GiraphTypes();
        super.readDirect(conf);
        if (!types.hasData() && (klass = ConfigurationUtils.getTypesHolderClass(conf)) != null) {
            types.inferFrom(klass);
        }
        return types;
    }

    public void inferFrom(Class<? extends TypesHolder> klass) {
        Class<?>[] classList = ReflectionUtils.getTypeArguments(TypesHolder.class, klass);
        Preconditions.checkArgument((classList.length == 5 ? 1 : 0) != 0);
        this.vertexIdClass = classList[0];
        this.vertexValueClass = classList[1];
        this.edgeValueClass = classList[2];
        this.incomingMessageValueClass = classList[3];
        this.outgoingMessageValueClass = classList[4];
    }

    private void readDirect(Configuration conf) {
        this.vertexIdClass = GiraphConstants.VERTEX_ID_CLASS.get(conf);
        this.vertexValueClass = GiraphConstants.VERTEX_VALUE_CLASS.get(conf);
        this.edgeValueClass = GiraphConstants.EDGE_VALUE_CLASS.get(conf);
        this.incomingMessageValueClass = GiraphConstants.INCOMING_MESSAGE_VALUE_CLASS.get(conf);
        this.outgoingMessageValueClass = GiraphConstants.OUTGOING_MESSAGE_VALUE_CLASS.get(conf);
        this.vertexClass = GiraphConstants.VERTEX_CLASS.get(conf);
    }

    public boolean hasData() {
        return this.vertexIdClass != null && this.vertexValueClass != null && this.edgeValueClass != null && this.incomingMessageValueClass != null && this.outgoingMessageValueClass != null;
    }

    public void writeTo(Configuration conf) {
        GiraphConstants.VERTEX_ID_CLASS.set(conf, this.vertexIdClass);
        GiraphConstants.VERTEX_VALUE_CLASS.set(conf, this.vertexValueClass);
        GiraphConstants.EDGE_VALUE_CLASS.set(conf, this.edgeValueClass);
        GiraphConstants.INCOMING_MESSAGE_VALUE_CLASS.set(conf, this.incomingMessageValueClass);
        GiraphConstants.OUTGOING_MESSAGE_VALUE_CLASS.set(conf, this.outgoingMessageValueClass);
    }

    public void writeIfUnset(Configuration conf) {
        GiraphConstants.VERTEX_ID_CLASS.setIfUnset(conf, this.vertexIdClass);
        GiraphConstants.VERTEX_VALUE_CLASS.setIfUnset(conf, this.vertexValueClass);
        GiraphConstants.EDGE_VALUE_CLASS.setIfUnset(conf, this.edgeValueClass);
        GiraphConstants.INCOMING_MESSAGE_VALUE_CLASS.setIfUnset(conf, this.incomingMessageValueClass);
        GiraphConstants.OUTGOING_MESSAGE_VALUE_CLASS.setIfUnset(conf, this.outgoingMessageValueClass);
    }

    public Class<E> getEdgeValueClass() {
        return this.edgeValueClass;
    }

    public Class<? extends Writable> getIncomingMessageValueClass() {
        return this.incomingMessageValueClass;
    }

    public Class<? extends Writable> getOutgoingMessageValueClass() {
        return this.outgoingMessageValueClass;
    }

    public Class<I> getVertexIdClass() {
        return this.vertexIdClass;
    }

    public Class<V> getVertexValueClass() {
        return this.vertexValueClass;
    }

    public Class<? extends Vertex> getVertexClass() {
        return this.vertexClass;
    }

    public void setEdgeValueClass(Class<E> edgeValueClass) {
        this.edgeValueClass = edgeValueClass;
    }

    public void setIncomingMessageValueClass(Class<? extends Writable> incomingMessageValueClass) {
        this.incomingMessageValueClass = incomingMessageValueClass;
    }

    public void setOutgoingMessageValueClass(Class<? extends Writable> outgoingMessageValueClass) {
        this.outgoingMessageValueClass = outgoingMessageValueClass;
    }

    public void setVertexIdClass(Class<I> vertexIdClass) {
        this.vertexIdClass = vertexIdClass;
    }

    public void setVertexValueClass(Class<V> vertexValueClass) {
        this.vertexValueClass = vertexValueClass;
    }
}

