/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import java.util.concurrent.TimeUnit;
import org.apache.giraph.aggregators.AggregatorWriter;
import org.apache.giraph.aggregators.TextAggregatorWriter;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.comm.messages.InMemoryMessageStoreFactory;
import org.apache.giraph.comm.messages.MessageEncodeAndStoreType;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.conf.BooleanConfOption;
import org.apache.giraph.conf.ClassConfOption;
import org.apache.giraph.conf.EnumConfOption;
import org.apache.giraph.conf.FloatConfOption;
import org.apache.giraph.conf.IntConfOption;
import org.apache.giraph.conf.LongConfOption;
import org.apache.giraph.conf.PerGraphTypeBooleanConfOption;
import org.apache.giraph.conf.PerGraphTypeEnumConfOption;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.conf.TypesHolder;
import org.apache.giraph.edge.ByteArrayEdges;
import org.apache.giraph.edge.EdgeStoreFactory;
import org.apache.giraph.edge.InMemoryEdgeStoreFactory;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.factories.ComputationFactory;
import org.apache.giraph.factories.DefaultComputationFactory;
import org.apache.giraph.factories.DefaultEdgeValueFactory;
import org.apache.giraph.factories.DefaultIncomingMessageValueFactory;
import org.apache.giraph.factories.DefaultOutgoingMessageValueFactory;
import org.apache.giraph.factories.DefaultVertexIdFactory;
import org.apache.giraph.factories.DefaultVertexValueFactory;
import org.apache.giraph.factories.EdgeValueFactory;
import org.apache.giraph.factories.MessageValueFactory;
import org.apache.giraph.factories.VertexIdFactory;
import org.apache.giraph.factories.VertexValueFactory;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.DefaultVertex;
import org.apache.giraph.graph.DefaultVertexResolver;
import org.apache.giraph.graph.DefaultVertexValueCombiner;
import org.apache.giraph.graph.Language;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexResolver;
import org.apache.giraph.graph.VertexValueCombiner;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeOutputFormat;
import org.apache.giraph.io.MappingInputFormat;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.filters.DefaultEdgeInputFilter;
import org.apache.giraph.io.filters.DefaultVertexInputFilter;
import org.apache.giraph.io.filters.EdgeInputFilter;
import org.apache.giraph.io.filters.VertexInputFilter;
import org.apache.giraph.job.DefaultGiraphJobRetryChecker;
import org.apache.giraph.job.DefaultJobObserver;
import org.apache.giraph.job.GiraphJobObserver;
import org.apache.giraph.job.GiraphJobRetryChecker;
import org.apache.giraph.job.HaltApplicationUtils;
import org.apache.giraph.mapping.MappingStore;
import org.apache.giraph.mapping.MappingStoreOps;
import org.apache.giraph.mapping.translate.TranslateEdge;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.giraph.master.MasterCompute;
import org.apache.giraph.master.MasterObserver;
import org.apache.giraph.partition.GraphPartitionerFactory;
import org.apache.giraph.partition.HashPartitionerFactory;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.SimplePartition;
import org.apache.giraph.worker.DefaultWorkerContext;
import org.apache.giraph.worker.WorkerContext;
import org.apache.giraph.worker.WorkerObserver;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public interface GiraphConstants {
    public static final int ONE_KB = 1024;
    public static final ClassConfOption<? extends MappingStore> MAPPING_STORE_CLASS = ClassConfOption.create("giraph.mappingStoreClass", null, MappingStore.class, "MappingStore Class");
    public static final ClassConfOption<? extends MappingStoreOps> MAPPING_STORE_OPS_CLASS = ClassConfOption.create("giraph.mappingStoreOpsClass", null, MappingStoreOps.class, "MappingStoreOps class");
    public static final IntConfOption LB_MAPPINGSTORE_UPPER = new IntConfOption("giraph.lbMappingStoreUpper", -1, "'upper' value used by lbmappingstore");
    public static final IntConfOption LB_MAPPINGSTORE_LOWER = new IntConfOption("giraph.lbMappingStoreLower", -1, "'lower' value used by lbMappingstore");
    public static final ClassConfOption EDGE_TRANSLATION_CLASS = ClassConfOption.create("giraph.edgeTranslationClass", null, TranslateEdge.class, "Class used to conduct expensive edge translation during vertex input phase");
    public static final ClassConfOption<Computation> COMPUTATION_CLASS = ClassConfOption.create("giraph.computationClass", null, Computation.class, "Computation class - required");
    public static final ClassConfOption<ComputationFactory> COMPUTATION_FACTORY_CLASS = ClassConfOption.create("giraph.computation.factory.class", DefaultComputationFactory.class, ComputationFactory.class, "Computation factory class - optional");
    public static final ClassConfOption<TypesHolder> TYPES_HOLDER_CLASS = ClassConfOption.create("giraph.typesHolder", null, TypesHolder.class, "TypesHolder, used if Computation not set - optional");
    public static final ClassConfOption<EdgeStoreFactory> EDGE_STORE_FACTORY_CLASS = ClassConfOption.create("giraph.edgeStoreFactoryClass", InMemoryEdgeStoreFactory.class, EdgeStoreFactory.class, "Edge Store Factory class to use for creating edgeStore");
    public static final ClassConfOption<MessageStoreFactory> MESSAGE_STORE_FACTORY_CLASS = ClassConfOption.create("giraph.messageStoreFactoryClass", InMemoryMessageStoreFactory.class, MessageStoreFactory.class, "Message Store Factory Class that is to be used");
    public static final PerGraphTypeEnumConfOption<Language> GRAPH_TYPE_LANGUAGES = PerGraphTypeEnumConfOption.create("giraph.types.language", Language.class, Language.JAVA, "Language user graph types (IVEMM) are implemented in");
    public static final PerGraphTypeBooleanConfOption GRAPH_TYPES_NEEDS_WRAPPERS = new PerGraphTypeBooleanConfOption("giraph.jython.type.wrappers", false, "Whether user graph types (IVEMM) need Jython wrappers");
    public static final ClassConfOption<VertexIdFactory> VERTEX_ID_FACTORY_CLASS = ClassConfOption.create("giraph.vertexIdFactoryClass", DefaultVertexIdFactory.class, VertexIdFactory.class, "Vertex ID factory class - optional");
    public static final ClassConfOption<VertexValueFactory> VERTEX_VALUE_FACTORY_CLASS = ClassConfOption.create("giraph.vertexValueFactoryClass", DefaultVertexValueFactory.class, VertexValueFactory.class, "Vertex value factory class - optional");
    public static final ClassConfOption<EdgeValueFactory> EDGE_VALUE_FACTORY_CLASS = ClassConfOption.create("giraph.edgeValueFactoryClass", DefaultEdgeValueFactory.class, EdgeValueFactory.class, "Edge value factory class - optional");
    public static final ClassConfOption<MessageValueFactory> INCOMING_MESSAGE_VALUE_FACTORY_CLASS = ClassConfOption.create("giraph.incomingMessageValueFactoryClass", DefaultIncomingMessageValueFactory.class, MessageValueFactory.class, "Incoming message value factory class - optional");
    public static final ClassConfOption<MessageValueFactory> OUTGOING_MESSAGE_VALUE_FACTORY_CLASS = ClassConfOption.create("giraph.outgoingMessageValueFactoryClass", DefaultOutgoingMessageValueFactory.class, MessageValueFactory.class, "Outgoing message value factory class - optional");
    public static final ClassConfOption<OutEdges> VERTEX_EDGES_CLASS = ClassConfOption.create("giraph.outEdgesClass", ByteArrayEdges.class, OutEdges.class, "Vertex edges class - optional");
    public static final ClassConfOption<OutEdges> INPUT_VERTEX_EDGES_CLASS = ClassConfOption.create("giraph.inputOutEdgesClass", ByteArrayEdges.class, OutEdges.class, "Vertex edges class to be used during edge input only - optional");
    public static final ClassConfOption<MasterCompute> MASTER_COMPUTE_CLASS = ClassConfOption.create("giraph.masterComputeClass", DefaultMasterCompute.class, MasterCompute.class, "Class for Master - optional");
    public static final ClassConfOption<MasterObserver> MASTER_OBSERVER_CLASSES = ClassConfOption.create("giraph.master.observers", null, MasterObserver.class, "Classes for Master Observer - optional");
    public static final ClassConfOption<WorkerObserver> WORKER_OBSERVER_CLASSES = ClassConfOption.create("giraph.worker.observers", null, WorkerObserver.class, "Classes for Worker Observer - optional");
    public static final ClassConfOption<MessageCombiner> MESSAGE_COMBINER_CLASS = ClassConfOption.create("giraph.messageCombinerClass", null, MessageCombiner.class, "Message combiner class - optional");
    public static final ClassConfOption<VertexResolver> VERTEX_RESOLVER_CLASS = ClassConfOption.create("giraph.vertexResolverClass", DefaultVertexResolver.class, VertexResolver.class, "Vertex resolver class - optional");
    public static final ClassConfOption<VertexValueCombiner> VERTEX_VALUE_COMBINER_CLASS = ClassConfOption.create("giraph.vertexValueCombinerClass", DefaultVertexValueCombiner.class, VertexValueCombiner.class, "Vertex value combiner class - optional");
    public static final EnumConfOption<Language> COMPUTATION_LANGUAGE = EnumConfOption.create("giraph.computation.language", Language.class, Language.JAVA, "Which language computation is implemented in");
    public static final BooleanConfOption RESOLVER_CREATE_VERTEX_ON_MSGS = new BooleanConfOption("giraph.vertex.resolver.create.on.msgs", true, "Option of whether to create vertexes that were not existent before but received messages");
    public static final ClassConfOption<GraphPartitionerFactory> GRAPH_PARTITIONER_FACTORY_CLASS = ClassConfOption.create("giraph.graphPartitionerFactoryClass", HashPartitionerFactory.class, GraphPartitionerFactory.class, "Graph partitioner factory class - optional");
    public static final ClassConfOption<GiraphJobObserver> JOB_OBSERVER_CLASS = ClassConfOption.create("giraph.jobObserverClass", DefaultJobObserver.class, GiraphJobObserver.class, "Observer class to watch over job status - optional");
    public static final ClassConfOption<GiraphJobRetryChecker> JOB_RETRY_CHECKER_CLASS = ClassConfOption.create("giraph.jobRetryCheckerClass", DefaultGiraphJobRetryChecker.class, GiraphJobRetryChecker.class, "Class which decides whether a failed job should be retried - optional");
    public static final LongConfOption MAX_ALLOWED_JOB_TIME_MS = new LongConfOption("giraph.maxAllowedJobTimeMilliseconds", -1L, "Maximum allowed time for job to run after getting all resources before it will be killed, in milliseconds (-1 if it has no limit)");
    public static final ClassConfOption<VertexInputFormat> VERTEX_INPUT_FORMAT_CLASS = ClassConfOption.create("giraph.vertexInputFormatClass", null, VertexInputFormat.class, "VertexInputFormat class (at least one of the input format classes is required)");
    public static final ClassConfOption<EdgeInputFormat> EDGE_INPUT_FORMAT_CLASS = ClassConfOption.create("giraph.edgeInputFormatClass", null, EdgeInputFormat.class, "EdgeInputFormat class");
    public static final ClassConfOption<MappingInputFormat> MAPPING_INPUT_FORMAT_CLASS = ClassConfOption.create("giraph.mappingInputFormatClass", null, MappingInputFormat.class, "MappingInputFormat class");
    public static final ClassConfOption<EdgeInputFilter> EDGE_INPUT_FILTER_CLASS = ClassConfOption.create("giraph.edgeInputFilterClass", DefaultEdgeInputFilter.class, EdgeInputFilter.class, "EdgeInputFilter class");
    public static final ClassConfOption<VertexInputFilter> VERTEX_INPUT_FILTER_CLASS = ClassConfOption.create("giraph.vertexInputFilterClass", DefaultVertexInputFilter.class, VertexInputFilter.class, "VertexInputFilter class");
    public static final ClassConfOption<Vertex> VERTEX_CLASS = ClassConfOption.create("giraph.vertexClass", DefaultVertex.class, Vertex.class, "Vertex class");
    public static final ClassConfOption<VertexOutputFormat> VERTEX_OUTPUT_FORMAT_CLASS = ClassConfOption.create("giraph.vertexOutputFormatClass", null, VertexOutputFormat.class, "VertexOutputFormat class");
    public static final StrConfOption VERTEX_OUTPUT_FORMAT_SUBDIR = new StrConfOption("giraph.vertex.output.subdir", "", "VertexOutputFormat sub-directory");
    public static final ClassConfOption<EdgeOutputFormat> EDGE_OUTPUT_FORMAT_CLASS = ClassConfOption.create("giraph.edgeOutputFormatClass", null, EdgeOutputFormat.class, "EdgeOutputFormat class");
    public static final StrConfOption EDGE_OUTPUT_FORMAT_SUBDIR = new StrConfOption("giraph.edge.output.subdir", "", "EdgeOutputFormat sub-directory");
    public static final StrConfOption GIRAPH_TEXT_OUTPUT_FORMAT_SEPARATOR = new StrConfOption("giraph.textoutputformat.separator", "\t", "GiraphTextOuputFormat Separator");
    public static final BooleanConfOption GIRAPH_TEXT_OUTPUT_FORMAT_REVERSE = new BooleanConfOption("giraph.textoutputformat.reverse", false, "Reverse values in the output");
    public static final BooleanConfOption DO_OUTPUT_DURING_COMPUTATION = new BooleanConfOption("giraph.doOutputDuringComputation", false, "If you use this option, instead of having saving vertices in the end of application, saveVertex will be called right after each vertex.compute() is called.NOTE: This feature doesn't work well with checkpointing - if you restart from a checkpoint you won't have any ouptut from previous supresteps.");
    public static final BooleanConfOption VERTEX_OUTPUT_FORMAT_THREAD_SAFE = new BooleanConfOption("giraph.vertexOutputFormatThreadSafe", false, "Vertex output format thread-safe - if your VertexOutputFormat allows several vertexWriters to be created and written to in parallel, you should set this to true.");
    public static final IntConfOption NUM_OUTPUT_THREADS = new IntConfOption("giraph.numOutputThreads", 1, "Number of threads for writing output in the end of the application");
    public static final StrConfOption GIRAPH_YARN_LIBJARS = new StrConfOption("giraph.yarn.libjars", "", "conf key for comma-separated list of jars to export to YARN workers");
    public static final String GIRAPH_YARN_CONF_FILE = "giraph-conf.xml";
    public static final int GIRAPH_YARN_TASK_HEAP_MB_DEFAULT = 1024;
    public static final IntConfOption GIRAPH_YARN_TASK_HEAP_MB = new IntConfOption("giraph.yarn.task.heap.mb", 1024, "Name of Giraph property for user-configurable heap memory per worker");
    public static final int GIRAPH_YARN_PRIORITY = 10;
    public static final BooleanConfOption IS_PURE_YARN_JOB = new BooleanConfOption("giraph.pure.yarn.job", false, "Is this a pure YARN job (i.e. no MapReduce layer managing Giraph tasks)");
    public static final ClassConfOption<WritableComparable> VERTEX_ID_CLASS = ClassConfOption.create("giraph.vertexIdClass", null, WritableComparable.class, "Vertex index class");
    public static final ClassConfOption<Writable> VERTEX_VALUE_CLASS = ClassConfOption.create("giraph.vertexValueClass", null, Writable.class, "Vertex value class");
    public static final ClassConfOption<Writable> EDGE_VALUE_CLASS = ClassConfOption.create("giraph.edgeValueClass", null, Writable.class, "Edge value class");
    public static final ClassConfOption<Writable> INCOMING_MESSAGE_VALUE_CLASS = ClassConfOption.create("giraph.incomingMessageValueClass", null, Writable.class, "Incoming message value class");
    public static final ClassConfOption<Writable> OUTGOING_MESSAGE_VALUE_CLASS = ClassConfOption.create("giraph.outgoingMessageValueClass", null, Writable.class, "Outgoing message value class");
    public static final ClassConfOption<WorkerContext> WORKER_CONTEXT_CLASS = ClassConfOption.create("giraph.workerContextClass", DefaultWorkerContext.class, WorkerContext.class, "Worker contextclass");
    public static final ClassConfOption<AggregatorWriter> AGGREGATOR_WRITER_CLASS = ClassConfOption.create("giraph.aggregatorWriterClass", TextAggregatorWriter.class, AggregatorWriter.class, "AggregatorWriter class - optional");
    public static final ClassConfOption<Partition> PARTITION_CLASS = ClassConfOption.create("giraph.partitionClass", SimplePartition.class, Partition.class, "Partition class - optional");
    public static final String MIN_WORKERS = "giraph.minWorkers";
    public static final String MAX_WORKERS = "giraph.maxWorkers";
    public static final BooleanConfOption SPLIT_MASTER_WORKER = new BooleanConfOption("giraph.SplitMasterWorker", true, "Separate the workers and the master tasks.  This is required to support dynamic recovery. (boolean)");
    public static final BooleanConfOption LOCAL_TEST_MODE = new BooleanConfOption("giraph.localTestMode", false, "Indicates whether this job is run in an internal unit test");
    public static final StrConfOption LOG_LEVEL = new StrConfOption("giraph.logLevel", "info", "Override the Hadoop log level and set the desired log level.");
    public static final BooleanConfOption LOG_THREAD_LAYOUT = new BooleanConfOption("giraph.logThreadLayout", false, "Use thread level debugging?");
    public static final BooleanConfOption JMAP_ENABLE = new BooleanConfOption("giraph.jmap.histo.enable", false, "Configuration key to enable jmap printing");
    public static final IntConfOption JMAP_SLEEP_MILLIS = new IntConfOption("giraph.jmap.histo.msec", TimeUnit.SECONDS.toMillis(30L), "Configuration key for msec to sleep between calls");
    public static final IntConfOption JMAP_PRINT_LINES = new IntConfOption("giraph.jmap.histo.print_lines", 30, "Configuration key for how many lines to print");
    public static final BooleanConfOption JMAP_LIVE_ONLY = new BooleanConfOption("giraph.jmap.histo.live", false, "Only print live objects in jmap?");
    public static final IntConfOption MIN_FREE_MBS_ON_HEAP = new IntConfOption("giraph.heap.minFreeMb", 128, "Option used by worker and master observers to check for imminent OOM exception");
    public static final BooleanConfOption REACTIVE_JMAP_ENABLE = new BooleanConfOption("giraph.heap.enableReactiveJmapDumping", false, "Option to enable dumping jmap histogram reactively based on free memory on heap");
    public static final FloatConfOption MIN_PERCENT_RESPONDED = new FloatConfOption("giraph.minPercentResponded", 100.0f, "Minimum percent of the maximum number of workers that have responded in order to continue progressing. (float)");
    public static final BooleanConfOption METRICS_ENABLE = new BooleanConfOption("giraph.metrics.enable", false, "Enable the Metrics system");
    public static final StrConfOption METRICS_DIRECTORY = new StrConfOption("giraph.metrics.directory", "", "Directory in HDFS to write master metrics to, instead of stderr");
    public static final StrConfOption ZOOKEEPER_LIST = new StrConfOption("giraph.zkList", "", "ZooKeeper comma-separated list (if not set, will start up ZooKeeper locally). Consider that after locally-starting zookeeper, this parameter will updated the configuration with the corrent configuration value.");
    public static final BooleanConfOption ZOOKEEPER_IS_EXTERNAL = new BooleanConfOption("giraph.zkIsExternal", true, "Zookeeper List will always hold a value during the computation while this option provides information regarding whether the zookeeper was internally started or externally provided.");
    public static final IntConfOption ZOOKEEPER_SESSION_TIMEOUT = new IntConfOption("giraph.zkSessionMsecTimeout", TimeUnit.MINUTES.toMillis(1L), "ZooKeeper session millisecond timeout");
    public static final IntConfOption ZOOKEEPER_SERVERLIST_POLL_MSECS = new IntConfOption("giraph.zkServerlistPollMsecs", TimeUnit.SECONDS.toMillis(3L), "Polling interval to check for the ZooKeeper server data");
    public static final IntConfOption ZOOKEEPER_SERVER_COUNT = new IntConfOption("giraph.zkServerCount", 1, "Number of nodes (not tasks) to run Zookeeper on");
    public static final IntConfOption ZOOKEEPER_SERVER_PORT = new IntConfOption("giraph.zkServerPort", 22181, "ZooKeeper port to use");
    public static final String ZOOKEEPER_DIR = "giraph.zkDir";
    public static final IntConfOption ZOOKEEPER_OPS_MAX_ATTEMPTS = new IntConfOption("giraph.zkOpsMaxAttempts", 3, "Max attempts for handling ZooKeeper connection loss");
    public static final IntConfOption ZOOKEEPER_OPS_RETRY_WAIT_MSECS = new IntConfOption("giraph.zkOpsRetryWaitMsecs", TimeUnit.SECONDS.toMillis(5L), "Msecs to wait before retrying a failed ZooKeeper op due to connection loss.");
    public static final IntConfOption TCP_BACKLOG = new IntConfOption("giraph.tcpBacklog", 1, "TCP backlog (defaults to number of workers)");
    public static final BooleanConfOption NETTY_USE_POOLED_ALLOCATOR = new BooleanConfOption("giraph.useNettyPooledAllocator", false, "Should netty use pooled memory allocator?");
    public static final BooleanConfOption NETTY_USE_DIRECT_MEMORY = new BooleanConfOption("giraph.useNettyDirectMemory", false, "Should netty use direct memory buffers");
    public static final IntConfOption NETTY_REQUEST_ENCODER_BUFFER_SIZE = new IntConfOption("giraph.nettyRequestEncoderBufferSize", 32768, "How big to make the encoder buffer?");
    public static final IntConfOption NETTY_CLIENT_THREADS = new IntConfOption("giraph.nettyClientThreads", 4, "Netty client threads");
    public static final IntConfOption NETTY_SERVER_THREADS = new IntConfOption("giraph.nettyServerThreads", 16, "Netty server threads");
    public static final BooleanConfOption NETTY_CLIENT_USE_EXECUTION_HANDLER = new BooleanConfOption("giraph.nettyClientUseExecutionHandler", true, "Use the execution handler in netty on the client?");
    public static final IntConfOption NETTY_CLIENT_EXECUTION_THREADS = new IntConfOption("giraph.nettyClientExecutionThreads", 8, "Netty client execution threads (execution handler)");
    public static final StrConfOption NETTY_CLIENT_EXECUTION_AFTER_HANDLER = new StrConfOption("giraph.nettyClientExecutionAfterHandler", "request-encoder", "Where to place the netty client execution handle?");
    public static final BooleanConfOption NETTY_SERVER_USE_EXECUTION_HANDLER = new BooleanConfOption("giraph.nettyServerUseExecutionHandler", true, "Use the execution handler in netty on the server?");
    public static final IntConfOption NETTY_SERVER_EXECUTION_THREADS = new IntConfOption("giraph.nettyServerExecutionThreads", 8, "Netty server execution threads (execution handler)");
    public static final StrConfOption NETTY_SERVER_EXECUTION_AFTER_HANDLER = new StrConfOption("giraph.nettyServerExecutionAfterHandler", "requestFrameDecoder", "Where to place the netty server execution handle?");
    public static final BooleanConfOption NETTY_SIMULATE_FIRST_REQUEST_CLOSED = new BooleanConfOption("giraph.nettySimulateFirstRequestClosed", false, "Netty simulate a first request closed");
    public static final BooleanConfOption NETTY_SIMULATE_FIRST_RESPONSE_FAILED = new BooleanConfOption("giraph.nettySimulateFirstResponseFailed", false, "Netty simulate a first response failed");
    public static final StrConfOption NETTY_COMPRESSION_ALGORITHM = new StrConfOption("giraph.nettyCompressionAlgorithm", "", "Which compression algorithm to use in netty");
    public static final IntConfOption MAX_RESOLVE_ADDRESS_ATTEMPTS = new IntConfOption("giraph.maxResolveAddressAttempts", 5, "Max resolve address attempts");
    public static final IntConfOption WAITING_REQUEST_MSECS = new IntConfOption("giraph.waitingRequestMsecs", TimeUnit.SECONDS.toMillis(15L), "Msecs to wait between waiting for all requests to finish");
    public static final IntConfOption EVENT_WAIT_MSECS = new IntConfOption("giraph.eventWaitMsecs", TimeUnit.SECONDS.toMillis(30L), "Millseconds to wait for an event before continuing");
    public static final IntConfOption MAX_MASTER_SUPERSTEP_WAIT_MSECS = new IntConfOption("giraph.maxMasterSuperstepWaitMsecs", TimeUnit.MINUTES.toMillis(10L), "Maximum milliseconds to wait before giving up trying to get the minimum number of workers before a superstep (int).");
    public static final IntConfOption MAX_REQUEST_MILLISECONDS = new IntConfOption("giraph.maxRequestMilliseconds", TimeUnit.MINUTES.toMillis(10L), "Milliseconds for a request to complete (or else resend)");
    public static final IntConfOption NETTY_MAX_CONNECTION_FAILURES = new IntConfOption("giraph.nettyMaxConnectionFailures", 1000, "Netty max connection failures");
    public static final IntConfOption IPC_INITIAL_PORT = new IntConfOption("giraph.ipcInitialPort", 30000, "Initial port to start using for the IPC communication");
    public static final IntConfOption MAX_IPC_PORT_BIND_ATTEMPTS = new IntConfOption("giraph.maxIpcPortBindAttempts", 20, "Maximum bind attempts for different IPC ports");
    public static final BooleanConfOption FAIL_FIRST_IPC_PORT_BIND_ATTEMPT = new BooleanConfOption("giraph.failFirstIpcPortBindAttempt", false, "Fail first IPC port binding attempt, simulate binding failure on real grid testing");
    public static final IntConfOption CLIENT_SEND_BUFFER_SIZE = new IntConfOption("giraph.clientSendBufferSize", 524288, "Client send buffer size");
    public static final IntConfOption CLIENT_RECEIVE_BUFFER_SIZE = new IntConfOption("giraph.clientReceiveBufferSize", 32768, "Client receive buffer size");
    public static final IntConfOption SERVER_SEND_BUFFER_SIZE = new IntConfOption("giraph.serverSendBufferSize", 32768, "Server send buffer size");
    public static final IntConfOption SERVER_RECEIVE_BUFFER_SIZE = new IntConfOption("giraph.serverReceiveBufferSize", 524288, "Server receive buffer size");
    public static final IntConfOption MAX_MSG_REQUEST_SIZE = new IntConfOption("giraph.msgRequestSize", 524288, "Maximum size of messages (in bytes) per peer before flush");
    public static final FloatConfOption ADDITIONAL_MSG_REQUEST_SIZE = new FloatConfOption("giraph.additionalMsgRequestSize", 0.2f, "How much bigger than the average per partition size to make initial per partition buffers. If this value is A, message request size is M, and a worker has P partitions, than its initial partition buffer size will be (M / P) * (1 + A).");
    public static final IntConfOption MAX_VERTEX_REQUEST_SIZE = new IntConfOption("giraph.vertexRequestSize", 524288, "Maximum size of vertices (in bytes) per peer before flush");
    public static final FloatConfOption ADDITIONAL_VERTEX_REQUEST_SIZE = new FloatConfOption("giraph.additionalVertexRequestSize", 0.2f, "Additional size (expressed as a ratio) of each per-partition buffer on top of the average size.");
    public static final IntConfOption MAX_EDGE_REQUEST_SIZE = new IntConfOption("giraph.edgeRequestSize", 524288, "Maximum size of edges (in bytes) per peer before flush");
    public static final FloatConfOption ADDITIONAL_EDGE_REQUEST_SIZE = new FloatConfOption("giraph.additionalEdgeRequestSize", 0.2f, "Additional size (expressed as a ratio) of each per-partition buffer on top of the average size.");
    public static final IntConfOption MAX_MUTATIONS_PER_REQUEST = new IntConfOption("giraph.maxMutationsPerRequest", 100, "Maximum number of mutations per partition before flush");
    public static final BooleanConfOption USE_MESSAGE_SIZE_ENCODING = new BooleanConfOption("giraph.useMessageSizeEncoding", false, "Use message size encoding (typically better for complex objects, not meant for primitive wrapped messages)");
    public static final IntConfOption CHANNELS_PER_SERVER = new IntConfOption("giraph.channelsPerServer", 1, "Number of channels used per server");
    public static final String MSG_NUM_FLUSH_THREADS = "giraph.msgNumFlushThreads";
    public static final IntConfOption NUM_COMPUTE_THREADS = new IntConfOption("giraph.numComputeThreads", 1, "Number of threads for vertex computation");
    public static final IntConfOption NUM_INPUT_THREADS = new IntConfOption("giraph.numInputThreads", 1, "Number of threads for input split loading");
    public static final IntConfOption PARTITION_LONG_TAIL_MIN_PRINT = new IntConfOption("giraph.partitionLongTailMinPrint", 1, "Minimum stragglers of the superstep before printing them out");
    public static final BooleanConfOption USE_SUPERSTEP_COUNTERS = new BooleanConfOption("giraph.useSuperstepCounters", true, "Use superstep counters? (boolean)");
    public static final FloatConfOption INPUT_SPLIT_SAMPLE_PERCENT = new FloatConfOption("giraph.inputSplitSamplePercent", 100.0f, "Input split sample percent - Used only for sampling and testing, rather than an actual job.  The idea is that to test, you might only want a fraction of the actual input splits from your VertexInputFormat to load (values should be [0, 100]).");
    public static final LongConfOption INPUT_SPLIT_MAX_VERTICES = new LongConfOption("giraph.InputSplitMaxVertices", -1L, "To limit outlier vertex input splits from producing too many vertices or to help with testing, the number of vertices loaded from an input split can be limited. By default, everything is loaded.");
    public static final LongConfOption INPUT_SPLIT_MAX_EDGES = new LongConfOption("giraph.InputSplitMaxEdges", -1L, "To limit outlier vertex input splits from producing too many vertices or to help with testing, the number of edges loaded from an input split can be limited. By default, everything is loaded.");
    public static final BooleanConfOption USE_INPUT_SPLIT_LOCALITY = new BooleanConfOption("giraph.useInputSplitLocality", true, "To minimize network usage when reading input splits, each worker can prioritize splits that reside on its host. This, however, comes at the cost of increased load on ZooKeeper. Hence, users with a lot of splits and input threads (or with configurations that can't exploit locality) may want to disable it.");
    public static final FloatConfOption PARTITION_COUNT_MULTIPLIER = new FloatConfOption("giraph.masterPartitionCountMultiplier", 1.0f, "Multiplier for the current workers squared");
    public static final IntConfOption USER_PARTITION_COUNT = new IntConfOption("giraph.userPartitionCount", -1, "Overrides default partition count calculation if not -1");
    public static final String PARTITION_VERTEX_KEY_SPACE_SIZE = "giraph.vertexKeySpaceSize";
    public static final StrConfOption ZOOKEEPER_JAVA_OPTS = new StrConfOption("giraph.zkJavaOpts", "-Xmx512m -XX:ParallelGCThreads=4 -XX:+UseConcMarkSweepGC -XX:CMSInitiatingOccupancyFraction=70 -XX:MaxGCPauseMillis=100", "Java opts passed to ZooKeeper startup");
    public static final IntConfOption CHECKPOINT_FREQUENCY = new IntConfOption("giraph.checkpointFrequency", 0, "How often to checkpoint (i.e. 0, means no checkpoint, 1 means every superstep, 2 is every two supersteps, etc.).");
    public static final BooleanConfOption CLEANUP_CHECKPOINTS_AFTER_SUCCESS = new BooleanConfOption("giraph.cleanupCheckpointsAfterSuccess", true, "Delete checkpoints after a successful job run?");
    public static final String RESTART_SUPERSTEP = "giraph.restartSuperstep";
    public static final StrConfOption RESTART_JOB_ID = new StrConfOption("giraph.restart.jobId", null, "Which job ID should I try to restart?");
    public static final String BASE_ZNODE_KEY = "giraph.zkBaseZNode";
    public static final StrConfOption ZOOKEEPER_MANAGER_DIRECTORY = new StrConfOption("giraph.zkManagerDirectory", "_bsp/_defaultZkManagerDir", "If ZOOKEEPER_LIST is not set, then use this directory to manage ZooKeeper");
    public static final IntConfOption ZOOKEEPER_CONNECTION_ATTEMPTS = new IntConfOption("giraph.zkConnectionAttempts", 10, "Number of ZooKeeper client connection attempts before giving up.");
    public static final StrConfOption CHECKPOINT_DIRECTORY = new StrConfOption("giraph.checkpointDirectory", "_bsp/_checkpoints/", "This directory has/stores the available checkpoint files in HDFS.");
    public static final StrConfOption MESSAGES_DIRECTORY = new StrConfOption("giraph.messagesDirectory", "_bsp/_messages/", "Comma-separated list of directories in the local file system for out-of-core messages.");
    public static final IntConfOption MAX_MESSAGES_IN_MEMORY = new IntConfOption("giraph.maxMessagesInMemory", 1000000, "If using out-of-core messaging, it tells how much messages do we keep in memory.");
    public static final IntConfOption MESSAGES_BUFFER_SIZE = new IntConfOption("giraph.messagesBufferSize", 8192, "Size of buffer when reading and writing messages out-of-core.");
    public static final StrConfOption PARTITIONS_DIRECTORY = new StrConfOption("giraph.partitionsDirectory", "_bsp/_partitions", "Comma-separated list of directories in the local filesystem for out-of-core partitions.");
    public static final BooleanConfOption USE_OUT_OF_CORE_GRAPH = new BooleanConfOption("giraph.useOutOfCoreGraph", false, "Enable out-of-core graph.");
    public static final String YOURKIT_OUTPUT_DIR = "giraph.yourkit.outputDir";
    public static final String YOURKIT_OUTPUT_DIR_DEFAULT = "/tmp/giraph/%JOB_ID%/%TASK_ID%";
    public static final IntConfOption MAX_PARTITIONS_IN_MEMORY = new IntConfOption("giraph.maxPartitionsInMemory", 10, "Maximum number of partitions to hold in memory for each worker.");
    public static final IntConfOption MAX_STICKY_PARTITIONS = new IntConfOption("giraph.stickyPartitions", 0, "Set number of sticky partitions if sticky mode is enabled.");
    public static final BooleanConfOption KEEP_ZOOKEEPER_DATA = new BooleanConfOption("giraph.keepZooKeeperData", false, "Keep the zookeeper output for debugging? Default is to remove it.");
    public static final int DEFAULT_ZOOKEEPER_TICK_TIME = 6000;
    public static final int DEFAULT_ZOOKEEPER_INIT_LIMIT = 10;
    public static final int DEFAULT_ZOOKEEPER_SYNC_LIMIT = 5;
    public static final int DEFAULT_ZOOKEEPER_SNAP_COUNT = 50000;
    public static final int DEFAULT_ZOOKEEPER_MAX_CLIENT_CNXNS = 10000;
    public static final IntConfOption ZOOKEEPER_MIN_SESSION_TIMEOUT = new IntConfOption("giraph.zKMinSessionTimeout", TimeUnit.MINUTES.toMillis(10L), "ZooKeeper minimum session timeout");
    public static final IntConfOption ZOOKEEPER_MAX_SESSION_TIMEOUT = new IntConfOption("giraph.zkMaxSessionTimeout", TimeUnit.MINUTES.toMillis(15L), "ZooKeeper maximum session timeout");
    public static final BooleanConfOption ZOOKEEPER_FORCE_SYNC = new BooleanConfOption("giraph.zKForceSync", false, "ZooKeeper force sync");
    public static final BooleanConfOption ZOOKEEPER_SKIP_ACL = new BooleanConfOption("giraph.ZkSkipAcl", true, "ZooKeeper skip ACLs");
    public static final BooleanConfOption AUTHENTICATE = new BooleanConfOption("giraph.authenticate", false, "Whether to use SASL with DIGEST and Hadoop Job Tokens to authenticate and authorize Netty BSP Clients to Servers.");
    public static final BooleanConfOption USE_UNSAFE_SERIALIZATION = new BooleanConfOption("giraph.useUnsafeSerialization", true, "Use unsafe serialization?");
    public static final BooleanConfOption USE_BIG_DATA_IO_FOR_MESSAGES = new BooleanConfOption("giraph.useBigDataIOForMessages", false, "Use BigDataIO for messages?");
    public static final IntConfOption MAX_TASK_ATTEMPTS = new IntConfOption("mapred.map.max.attempts", -1, "Maximum number of attempts a master/worker will retry before killing the job.  This directly maps to the number of map task attempts in Hadoop.");
    public static final StrConfOption DNS_INTERFACE = new StrConfOption("giraph.dns.interface", "default", "Interface to use for hostname resolution");
    public static final StrConfOption DNS_NAMESERVER = new StrConfOption("giraph.dns.nameserver", "default", "Server for hostname resolution");
    public static final IntConfOption MAX_NUMBER_OF_SUPERSTEPS = new IntConfOption("giraph.maxNumberOfSupersteps", 1, "The application will halt after this many supersteps is completed. For instance, if it is set to 3, the application will run at most 0, 1, and 2 supersteps and then go into the shutdown superstep.");
    public static final BooleanConfOption STATIC_GRAPH = new BooleanConfOption("giraph.isStaticGraph", false, "The application will not mutate the graph topology (the edges). It is used to optimise out-of-core graph, by not writing back edges every time.");
    public static final EnumConfOption<MessageEncodeAndStoreType> MESSAGE_ENCODE_AND_STORE_TYPE = EnumConfOption.create("giraph.messageEncodeAndStoreType", MessageEncodeAndStoreType.class, MessageEncodeAndStoreType.BYTEARRAY_PER_PARTITION, "Select the message_encode_and_store_type to use");
    public static final BooleanConfOption CREATE_EDGE_SOURCE_VERTICES = new BooleanConfOption("giraph.createEdgeSourceVertices", true, "Create a source vertex if present in edge input but not necessarily in vertex input");
    public static final String ZOOKEEPER_SERVER_PORT_COUNTER_GROUP = "Zookeeper server:port";
    public static final String ZOOKEEPER_HALT_NODE_COUNTER_GROUP = "Zookeeper halt node";
    public static final String ZOOKEEPER_BASE_PATH_COUNTER_GROUP = "Zookeeper base path";
    public static final ClassConfOption<HaltApplicationUtils.HaltInstructionsWriter> HALT_INSTRUCTIONS_WRITER_CLASS = ClassConfOption.create("giraph.haltInstructionsWriter", HaltApplicationUtils.DefaultHaltInstructionsWriter.class, HaltApplicationUtils.HaltInstructionsWriter.class, "Class used to write instructions on how to halt the application");
    public static final IntConfOption WAIT_TASK_DONE_TIMEOUT_MS = new IntConfOption("giraph.waitTaskDoneTimeoutMs", TimeUnit.MINUTES.toMillis(15L), "Maximum timeout (in ms) for waiting for all all tasks to complete");
    public static final BooleanConfOption TRACK_JOB_PROGRESS_ON_CLIENT = new BooleanConfOption("giraph.trackJobProgressOnClient", false, "Whether to track job progress on client or not");
    public static final IntConfOption HDFS_FILE_CREATION_RETRIES = new IntConfOption("giraph.hdfs.file.creation.retries", 10, "Retries to create an HDFS file before failing");
    public static final IntConfOption HDFS_FILE_CREATION_RETRY_WAIT_MS = new IntConfOption("giraph.hdfs.file.creation.retry.wait.ms", 30000, "Milliseconds to wait prior to retrying creation of an HDFS file");
    public static final IntConfOption NUM_CHECKPOINT_IO_THREADS = new IntConfOption("giraph.checkpoint.io.threads", 8, "Number of threads for writing and reading checkpoints");
    public static final StrConfOption CHECKPOINT_COMPRESSION_CODEC = new StrConfOption("giraph.checkpoint.compression.codec", ".deflate", "Defines compression algorithm we will be using for storing checkpoint. Available options include but not restricted to: .deflate, .gz, .bz2, .lzo");
    public static final IntConfOption ASYNC_MESSAGE_STORE_THREADS_COUNT = new IntConfOption("giraph.async.message.store.threads", 0, "Number of threads to be used in async message store.");
}

