/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import java.net.UnknownHostException;
import org.apache.giraph.aggregators.AggregatorWriter;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.comm.messages.MessageEncodeAndStoreType;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.edge.ReuseObjectsOutEdges;
import org.apache.giraph.factories.ComputationFactory;
import org.apache.giraph.factories.VertexValueFactory;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexResolver;
import org.apache.giraph.graph.VertexValueCombiner;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeOutputFormat;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.filters.EdgeInputFilter;
import org.apache.giraph.io.filters.VertexInputFilter;
import org.apache.giraph.job.GiraphJobObserver;
import org.apache.giraph.job.GiraphJobRetryChecker;
import org.apache.giraph.master.MasterCompute;
import org.apache.giraph.master.MasterObserver;
import org.apache.giraph.partition.GraphPartitionerFactory;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.ReusesObjectsPartition;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.giraph.worker.WorkerContext;
import org.apache.giraph.worker.WorkerObserver;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.net.DNS;

public class GiraphConfiguration
extends Configuration
implements GiraphConstants {
    private ByteBufAllocator nettyBufferAllocator = null;

    public GiraphConfiguration() {
        this.configureHadoopSecurity();
    }

    public GiraphConfiguration(Configuration conf) {
        super(conf);
        this.configureHadoopSecurity();
    }

    public String getComputationName() {
        ComputationFactory compFactory = ReflectionUtils.newInstance(this.getComputationFactoryClass());
        return compFactory.computationName(this);
    }

    public Class<? extends ComputationFactory> getComputationFactoryClass() {
        return COMPUTATION_FACTORY_CLASS.get(this);
    }

    public Class<? extends Computation> getComputationClass() {
        return COMPUTATION_CLASS.get(this);
    }

    public void setComputationClass(Class<? extends Computation> computationClass) {
        COMPUTATION_CLASS.set(this, computationClass);
    }

    public final void setVertexValueFactoryClass(Class<? extends VertexValueFactory> vertexValueFactoryClass) {
        VERTEX_VALUE_FACTORY_CLASS.set(this, vertexValueFactoryClass);
    }

    public void setEdgeInputFilterClass(Class<? extends EdgeInputFilter> edgeFilterClass) {
        EDGE_INPUT_FILTER_CLASS.set(this, edgeFilterClass);
    }

    public void setVertexInputFilterClass(Class<? extends VertexInputFilter> vertexFilterClass) {
        VERTEX_INPUT_FILTER_CLASS.set(this, vertexFilterClass);
    }

    public Class<? extends OutEdges> getOutEdgesClass() {
        return VERTEX_EDGES_CLASS.get(this);
    }

    public final void setOutEdgesClass(Class<? extends OutEdges> outEdgesClass) {
        VERTEX_EDGES_CLASS.set(this, outEdgesClass);
    }

    public final void setVertexClass(Class<? extends Vertex> vertexClass) {
        VERTEX_CLASS.set(this, vertexClass);
    }

    public final void setInputOutEdgesClass(Class<? extends OutEdges> inputOutEdgesClass) {
        INPUT_VERTEX_EDGES_CLASS.set(this, inputOutEdgesClass);
    }

    public boolean reuseEdgeObjects() {
        return ReuseObjectsOutEdges.class.isAssignableFrom(this.getOutEdgesClass());
    }

    public boolean reuseVertexObjects() {
        return ReusesObjectsPartition.class.isAssignableFrom(this.getPartitionClass());
    }

    public Class<? extends Partition> getPartitionClass() {
        return PARTITION_CLASS.get(this);
    }

    public boolean hasVertexInputFormat() {
        return VERTEX_INPUT_FORMAT_CLASS.get(this) != null;
    }

    public void setVertexInputFormatClass(Class<? extends VertexInputFormat> vertexInputFormatClass) {
        VERTEX_INPUT_FORMAT_CLASS.set(this, vertexInputFormatClass);
    }

    public boolean hasEdgeInputFormat() {
        return EDGE_INPUT_FORMAT_CLASS.get(this) != null;
    }

    public void setEdgeInputFormatClass(Class<? extends EdgeInputFormat> edgeInputFormatClass) {
        EDGE_INPUT_FORMAT_CLASS.set(this, edgeInputFormatClass);
    }

    public final void setMasterComputeClass(Class<? extends MasterCompute> masterComputeClass) {
        MASTER_COMPUTE_CLASS.set(this, masterComputeClass);
    }

    public final void addMasterObserverClass(Class<? extends MasterObserver> masterObserverClass) {
        MASTER_OBSERVER_CLASSES.add(this, masterObserverClass);
    }

    public final void addWorkerObserverClass(Class<? extends WorkerObserver> workerObserverClass) {
        WORKER_OBSERVER_CLASSES.add(this, workerObserverClass);
    }

    public Class<? extends GiraphJobObserver> getJobObserverClass() {
        return JOB_OBSERVER_CLASS.get(this);
    }

    public void setJobObserverClass(Class<? extends GiraphJobObserver> klass) {
        JOB_OBSERVER_CLASS.set(this, klass);
    }

    public Class<? extends GiraphJobRetryChecker> getJobRetryCheckerClass() {
        return JOB_RETRY_CHECKER_CLASS.get(this);
    }

    public void setJobRetryCheckerClass(Class<? extends GiraphJobRetryChecker> klass) {
        JOB_RETRY_CHECKER_CLASS.set(this, klass);
    }

    public boolean isJMapHistogramDumpEnabled() {
        return JMAP_ENABLE.get(this);
    }

    public boolean isReactiveJmapHistogramDumpEnabled() {
        return REACTIVE_JMAP_ENABLE.get(this);
    }

    public final void setClasses(String name, Class<?> xface, Class<?> ... klasses) {
        String[] klassNames = new String[klasses.length];
        for (int i = 0; i < klasses.length; ++i) {
            Class<?> klass = klasses[i];
            if (!xface.isAssignableFrom(klass)) {
                throw new RuntimeException(klass + " does not implement " + xface.getName());
            }
            klassNames[i] = klasses[i].getName();
        }
        this.setStrings(name, klassNames);
    }

    public boolean hasVertexOutputFormat() {
        return VERTEX_OUTPUT_FORMAT_CLASS.get(this) != null;
    }

    public final void setVertexOutputFormatClass(Class<? extends VertexOutputFormat> vertexOutputFormatClass) {
        VERTEX_OUTPUT_FORMAT_CLASS.set(this, vertexOutputFormatClass);
    }

    public boolean hasVertexOutputFormatSubdir() {
        return !VERTEX_OUTPUT_FORMAT_SUBDIR.get(this).isEmpty();
    }

    public final void setVertexOutputFormatSubdir(String path) {
        VERTEX_OUTPUT_FORMAT_SUBDIR.set(this, path);
    }

    public final boolean doOutputDuringComputation() {
        return DO_OUTPUT_DURING_COMPUTATION.get(this);
    }

    public final void setDoOutputDuringComputation(boolean doOutputDuringComputation) {
        DO_OUTPUT_DURING_COMPUTATION.set(this, doOutputDuringComputation);
    }

    public final boolean vertexOutputFormatThreadSafe() {
        return VERTEX_OUTPUT_FORMAT_THREAD_SAFE.get(this);
    }

    public final void setVertexOutputFormatThreadSafe(boolean vertexOutputFormatThreadSafe) {
        VERTEX_OUTPUT_FORMAT_THREAD_SAFE.set(this, vertexOutputFormatThreadSafe);
    }

    public boolean hasEdgeOutputFormat() {
        return EDGE_OUTPUT_FORMAT_CLASS.get(this) != null;
    }

    public final void setEdgeOutputFormatClass(Class<? extends EdgeOutputFormat> edgeOutputFormatClass) {
        EDGE_OUTPUT_FORMAT_CLASS.set(this, edgeOutputFormatClass);
    }

    public boolean hasEdgeOutputFormatSubdir() {
        return !EDGE_OUTPUT_FORMAT_SUBDIR.get(this).isEmpty();
    }

    public final void setEdgeOutputFormatSubdir(String path) {
        EDGE_OUTPUT_FORMAT_SUBDIR.set(this, path);
    }

    public final int getNumOutputThreads() {
        if (!this.vertexOutputFormatThreadSafe()) {
            return 1;
        }
        return NUM_OUTPUT_THREADS.get(this);
    }

    public void setNumOutputThreads(int numOutputThreads) {
        NUM_OUTPUT_THREADS.set(this, numOutputThreads);
    }

    public Class<? extends MessageCombiner> getMessageCombinerClass() {
        return MESSAGE_COMBINER_CLASS.get(this);
    }

    public void setMessageCombinerClass(Class<? extends MessageCombiner> messageCombinerClass) {
        MESSAGE_COMBINER_CLASS.set(this, messageCombinerClass);
    }

    public final void setGraphPartitionerFactoryClass(Class<? extends GraphPartitionerFactory> graphPartitionerFactoryClass) {
        GRAPH_PARTITIONER_FACTORY_CLASS.set(this, graphPartitionerFactoryClass);
    }

    public final void setVertexResolverClass(Class<? extends VertexResolver> vertexResolverClass) {
        VERTEX_RESOLVER_CLASS.set(this, vertexResolverClass);
    }

    public final boolean getResolverCreateVertexOnMessages() {
        return RESOLVER_CREATE_VERTEX_ON_MSGS.get(this);
    }

    public final void setResolverCreateVertexOnMessages(boolean v) {
        RESOLVER_CREATE_VERTEX_ON_MSGS.set(this, v);
    }

    public final void setVertexValueCombinerClass(Class<? extends VertexValueCombiner> vertexValueCombinerClass) {
        VERTEX_VALUE_COMBINER_CLASS.set(this, vertexValueCombinerClass);
    }

    public final void setWorkerContextClass(Class<? extends WorkerContext> workerContextClass) {
        WORKER_CONTEXT_CLASS.set(this, workerContextClass);
    }

    public final void setAggregatorWriterClass(Class<? extends AggregatorWriter> aggregatorWriterClass) {
        AGGREGATOR_WRITER_CLASS.set(this, aggregatorWriterClass);
    }

    public final void setPartitionClass(Class<? extends Partition> partitionClass) {
        PARTITION_CLASS.set(this, partitionClass);
    }

    public final void setWorkerConfiguration(int minWorkers, int maxWorkers, float minPercentResponded) {
        this.setInt("giraph.minWorkers", minWorkers);
        this.setInt("giraph.maxWorkers", maxWorkers);
        MIN_PERCENT_RESPONDED.set(this, minPercentResponded);
    }

    public final int getMinWorkers() {
        return this.getInt("giraph.minWorkers", -1);
    }

    public final int getMaxWorkers() {
        return this.getInt("giraph.maxWorkers", -1);
    }

    public final float getMinPercentResponded() {
        return MIN_PERCENT_RESPONDED.get(this);
    }

    public final void setZooKeeperConfiguration(String serverList) {
        ZOOKEEPER_LIST.set(this, serverList);
    }

    public final boolean getSplitMasterWorker() {
        return SPLIT_MASTER_WORKER.get(this);
    }

    public Class<? extends MasterObserver>[] getMasterObserverClasses() {
        return MASTER_OBSERVER_CLASSES.getArray(this);
    }

    public Class<? extends WorkerObserver>[] getWorkerObserverClasses() {
        return WORKER_OBSERVER_CLASSES.getArray(this);
    }

    public boolean metricsEnabled() {
        return METRICS_ENABLE.isTrue(this);
    }

    public int getTaskPartition() {
        return this.getInt("mapred.task.partition", -1);
    }

    public boolean isPureYarnJob() {
        return IS_PURE_YARN_JOB.get(this);
    }

    public String getYarnLibJars() {
        return GIRAPH_YARN_LIBJARS.get(this);
    }

    public void setYarnLibJars(String jarList) {
        GIRAPH_YARN_LIBJARS.set(this, jarList);
    }

    public int getYarnTaskHeapMb() {
        return GIRAPH_YARN_TASK_HEAP_MB.get(this);
    }

    public void setYarnTaskHeapMb(int heapMb) {
        GIRAPH_YARN_TASK_HEAP_MB.set(this, heapMb);
    }

    public String getZookeeperList() {
        return ZOOKEEPER_LIST.get(this);
    }

    public void setZookeeperList(String zkList) {
        ZOOKEEPER_LIST.set(this, zkList);
        ZOOKEEPER_IS_EXTERNAL.set(this, false);
    }

    public boolean isZookeeperExternal() {
        return ZOOKEEPER_IS_EXTERNAL.get(this);
    }

    public String getLocalLevel() {
        return LOG_LEVEL.get(this);
    }

    public boolean useLogThreadLayout() {
        return LOG_THREAD_LAYOUT.get(this);
    }

    public boolean getLocalTestMode() {
        return LOCAL_TEST_MODE.get(this);
    }

    public void setLocalTestMode(boolean flag) {
        LOCAL_TEST_MODE.set(this, flag);
    }

    public int getZooKeeperServerCount() {
        return ZOOKEEPER_SERVER_COUNT.get(this);
    }

    public int getZooKeeperSessionTimeout() {
        return ZOOKEEPER_SESSION_TIMEOUT.get(this);
    }

    public int getZookeeperOpsMaxAttempts() {
        return ZOOKEEPER_OPS_MAX_ATTEMPTS.get(this);
    }

    public int getZookeeperOpsRetryWaitMsecs() {
        return ZOOKEEPER_OPS_RETRY_WAIT_MSECS.get(this);
    }

    public boolean getNettyServerUseExecutionHandler() {
        return NETTY_SERVER_USE_EXECUTION_HANDLER.get(this);
    }

    public int getNettyServerThreads() {
        return NETTY_SERVER_THREADS.get(this);
    }

    public int getNettyServerExecutionThreads() {
        return NETTY_SERVER_EXECUTION_THREADS.get(this);
    }

    public int getNettyServerExecutionConcurrency() {
        if (this.getNettyServerUseExecutionHandler()) {
            return this.getNettyServerExecutionThreads();
        }
        return this.getNettyServerThreads();
    }

    public ByteBufAllocator getNettyAllocator() {
        if (this.nettyBufferAllocator == null) {
            this.nettyBufferAllocator = NETTY_USE_POOLED_ALLOCATOR.get(this) ? new PooledByteBufAllocator(NETTY_USE_DIRECT_MEMORY.get(this)) : new UnpooledByteBufAllocator(NETTY_USE_DIRECT_MEMORY.get(this));
        }
        return this.nettyBufferAllocator;
    }

    public int getZookeeperConnectionAttempts() {
        return ZOOKEEPER_CONNECTION_ATTEMPTS.get(this);
    }

    public int getZooKeeperMinSessionTimeout() {
        return ZOOKEEPER_MIN_SESSION_TIMEOUT.get(this);
    }

    public int getZooKeeperMaxSessionTimeout() {
        return ZOOKEEPER_MAX_SESSION_TIMEOUT.get(this);
    }

    public boolean getZooKeeperForceSync() {
        return ZOOKEEPER_FORCE_SYNC.get(this);
    }

    public boolean getZooKeeperSkipAcl() {
        return ZOOKEEPER_SKIP_ACL.get(this);
    }

    public int getMapTasks() {
        int mapTasks = this.getInt("mapred.map.tasks", -1);
        if (mapTasks == -1) {
            throw new IllegalStateException("getMapTasks: Failed to get the map tasks!");
        }
        return mapTasks;
    }

    public boolean authenticate() {
        return AUTHENTICATE.get(this);
    }

    public void setNumComputeThreads(int numComputeThreads) {
        NUM_COMPUTE_THREADS.set(this, numComputeThreads);
    }

    public int getNumComputeThreads() {
        return NUM_COMPUTE_THREADS.get(this);
    }

    public void setNumInputSplitsThreads(int numInputSplitsThreads) {
        NUM_INPUT_THREADS.set(this, numInputSplitsThreads);
    }

    public int getNumInputSplitsThreads() {
        return NUM_INPUT_THREADS.get(this);
    }

    public long getInputSplitMaxVertices() {
        return INPUT_SPLIT_MAX_VERTICES.get(this);
    }

    public long getInputSplitMaxEdges() {
        return INPUT_SPLIT_MAX_EDGES.get(this);
    }

    public void useUnsafeSerialization(boolean useUnsafeSerialization) {
        USE_UNSAFE_SERIALIZATION.set(this, useUnsafeSerialization);
    }

    public boolean useMessageSizeEncoding() {
        return USE_MESSAGE_SIZE_ENCODING.get(this);
    }

    public void setCheckpointFrequency(int checkpointFrequency) {
        CHECKPOINT_FREQUENCY.set(this, checkpointFrequency);
    }

    public int getCheckpointFrequency() {
        return CHECKPOINT_FREQUENCY.get(this);
    }

    public boolean useCheckpointing() {
        return this.getCheckpointFrequency() != 0;
    }

    public void setMaxTaskAttempts(int maxTaskAttempts) {
        MAX_TASK_ATTEMPTS.set(this, maxTaskAttempts);
    }

    public int getMaxTaskAttempts() {
        return MAX_TASK_ATTEMPTS.get(this);
    }

    public int getEventWaitMsecs() {
        return EVENT_WAIT_MSECS.get(this);
    }

    public void setEventWaitMsecs(int eventWaitMsecs) {
        EVENT_WAIT_MSECS.set(this, eventWaitMsecs);
    }

    public int getMaxMasterSuperstepWaitMsecs() {
        return MAX_MASTER_SUPERSTEP_WAIT_MSECS.get(this);
    }

    public void setMaxMasterSuperstepWaitMsecs(int maxMasterSuperstepWaitMsecs) {
        MAX_MASTER_SUPERSTEP_WAIT_MSECS.set(this, maxMasterSuperstepWaitMsecs);
    }

    public void configureHadoopSecurity() {
        String hadoopTokenFilePath = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
        if (hadoopTokenFilePath != null) {
            this.set("mapreduce.job.credentials.binary", hadoopTokenFilePath);
        }
    }

    public boolean useInputSplitLocality() {
        return USE_INPUT_SPLIT_LOCALITY.get(this);
    }

    public String getLocalHostname() throws UnknownHostException {
        return DNS.getDefaultHost((String)GiraphConstants.DNS_INTERFACE.get(this), (String)GiraphConstants.DNS_NAMESERVER.get(this)).toLowerCase();
    }

    public void setMaxNumberOfSupersteps(int maxNumberOfSupersteps) {
        MAX_NUMBER_OF_SUPERSTEPS.set(this, maxNumberOfSupersteps);
    }

    public int getMaxNumberOfSupersteps() {
        return MAX_NUMBER_OF_SUPERSTEPS.get(this);
    }

    public boolean isStaticGraph() {
        return STATIC_GRAPH.isTrue(this);
    }

    public String getYourKitOutputDir(Mapper.Context context) {
        String cacheKey = "giraph.yourkit.outputDirCached";
        String outputDir = this.get("giraph.yourkit.outputDirCached");
        if (outputDir == null) {
            outputDir = this.getStringVars("giraph.yourkit.outputDir", "/tmp/giraph/%JOB_ID%/%TASK_ID%", context);
            this.set("giraph.yourkit.outputDirCached", outputDir);
        }
        return outputDir;
    }

    public String getStringVars(String key, Mapper.Context context) {
        return this.getStringVars(key, null, context);
    }

    public String getStringVars(String key, String defaultValue, Mapper.Context context) {
        String value = this.get(key);
        if (value == null) {
            if (defaultValue == null) {
                return null;
            }
            value = defaultValue;
        }
        value = value.replace("%JOB_ID%", context.getJobID().toString());
        value = value.replace("%TASK_ID%", context.getTaskAttemptID().toString());
        value = value.replace("%USER%", this.get("user.name", "unknown_user"));
        return value;
    }

    public boolean useOneMessageToManyIdsEncoding() {
        return ((MessageEncodeAndStoreType)((Object)MESSAGE_ENCODE_AND_STORE_TYPE.get(this))).useOneMessageToManyIdsEncoding();
    }

    public boolean getCreateSourceVertex() {
        return CREATE_EDGE_SOURCE_VERTICES.get(this);
    }

    public void setCreateSourceVertex(boolean createVertex) {
        CREATE_EDGE_SOURCE_VERTICES.set(this, createVertex);
    }

    public int getWaitTaskDoneTimeoutMs() {
        return WAIT_TASK_DONE_TIMEOUT_MS.get(this);
    }

    public void setWaitTaskDoneTimeoutMs(int ms) {
        WAIT_TASK_DONE_TIMEOUT_MS.set(this, ms);
    }

    public boolean trackJobProgressOnClient() {
        return TRACK_JOB_PROGRESS_ON_CLIENT.get(this);
    }

    public int getHdfsFileCreationRetries() {
        return HDFS_FILE_CREATION_RETRIES.get(this);
    }

    public int getHdfsFileCreationRetryWaitMs() {
        return HDFS_FILE_CREATION_RETRY_WAIT_MS.get(this);
    }
}

