/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import org.apache.giraph.aggregators.AggregatorWriter;
import org.apache.giraph.aggregators.TextAggregatorWriter;
import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.GiraphTypes;
import org.apache.giraph.edge.ByteArrayEdges;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.factories.ComputationFactory;
import org.apache.giraph.factories.DefaultComputationFactory;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.graph.DefaultVertexResolver;
import org.apache.giraph.graph.DefaultVertexValueCombiner;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexResolver;
import org.apache.giraph.graph.VertexValueCombiner;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeOutputFormat;
import org.apache.giraph.io.MappingInputFormat;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.filters.DefaultEdgeInputFilter;
import org.apache.giraph.io.filters.DefaultVertexInputFilter;
import org.apache.giraph.io.filters.EdgeInputFilter;
import org.apache.giraph.io.filters.VertexInputFilter;
import org.apache.giraph.master.DefaultMasterCompute;
import org.apache.giraph.master.MasterCompute;
import org.apache.giraph.partition.GraphPartitionerFactory;
import org.apache.giraph.partition.HashPartitionerFactory;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.SimplePartition;
import org.apache.giraph.worker.DefaultWorkerContext;
import org.apache.giraph.worker.WorkerContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class GiraphClasses<I extends WritableComparable, V extends Writable, E extends Writable>
implements GiraphConstants {
    protected Class<? extends ComputationFactory<I, V, E, ? extends Writable, ? extends Writable>> computationFactoryClass;
    protected Class<? extends Computation<I, V, E, ? extends Writable, ? extends Writable>> computationClass;
    protected GiraphTypes<I, V, E> giraphTypes;
    protected Class<? extends OutEdges<I, E>> outEdgesClass;
    protected Class<? extends OutEdges<I, E>> inputOutEdgesClass;
    protected Class<? extends GraphPartitionerFactory<I, V, E>> graphPartitionerFactoryClass;
    protected Class<? extends VertexInputFormat<I, V, E>> vertexInputFormatClass;
    protected Class<? extends VertexOutputFormat<I, V, E>> vertexOutputFormatClass;
    protected Class<? extends MappingInputFormat<I, V, E, ? extends Writable>> mappingInputFormatClass;
    protected Class<? extends EdgeInputFormat<I, E>> edgeInputFormatClass;
    protected Class<? extends EdgeOutputFormat<I, V, E>> edgeOutputFormatClass;
    protected Class<? extends AggregatorWriter> aggregatorWriterClass;
    protected Class<? extends MessageCombiner<I, ? extends Writable>> messageCombinerClass;
    protected Class<? extends VertexResolver<I, V, E>> vertexResolverClass;
    protected Class<? extends VertexValueCombiner<V>> vertexValueCombinerClass;
    protected Class<? extends WorkerContext> workerContextClass;
    protected Class<? extends MasterCompute> masterComputeClass;
    protected Class<? extends Partition<I, V, E>> partitionClass;
    protected Class<? extends EdgeInputFilter<I, E>> edgeInputFilterClass;
    protected Class<? extends VertexInputFilter<I, V, E>> vertexInputFilterClass;

    public GiraphClasses() {
        this.computationFactoryClass = DefaultComputationFactory.class;
        this.giraphTypes = new GiraphTypes();
        this.outEdgesClass = ByteArrayEdges.class;
        this.inputOutEdgesClass = ByteArrayEdges.class;
        this.graphPartitionerFactoryClass = HashPartitionerFactory.class;
        this.aggregatorWriterClass = TextAggregatorWriter.class;
        this.vertexResolverClass = DefaultVertexResolver.class;
        this.vertexValueCombinerClass = DefaultVertexValueCombiner.class;
        this.workerContextClass = DefaultWorkerContext.class;
        this.masterComputeClass = DefaultMasterCompute.class;
        this.partitionClass = SimplePartition.class;
        this.edgeInputFilterClass = DefaultEdgeInputFilter.class;
        this.vertexInputFilterClass = DefaultVertexInputFilter.class;
    }

    public GiraphClasses(Configuration conf) {
        this.giraphTypes = GiraphTypes.readFrom(conf);
        this.computationFactoryClass = COMPUTATION_FACTORY_CLASS.get(conf);
        this.computationClass = COMPUTATION_CLASS.get(conf);
        this.outEdgesClass = VERTEX_EDGES_CLASS.get(conf);
        this.inputOutEdgesClass = INPUT_VERTEX_EDGES_CLASS.getWithDefault(conf, this.outEdgesClass);
        this.graphPartitionerFactoryClass = GRAPH_PARTITIONER_FACTORY_CLASS.get(conf);
        this.vertexInputFormatClass = VERTEX_INPUT_FORMAT_CLASS.get(conf);
        this.vertexOutputFormatClass = VERTEX_OUTPUT_FORMAT_CLASS.get(conf);
        this.edgeInputFormatClass = EDGE_INPUT_FORMAT_CLASS.get(conf);
        this.edgeOutputFormatClass = EDGE_OUTPUT_FORMAT_CLASS.get(conf);
        this.mappingInputFormatClass = MAPPING_INPUT_FORMAT_CLASS.get(conf);
        this.aggregatorWriterClass = AGGREGATOR_WRITER_CLASS.get(conf);
        this.messageCombinerClass = MESSAGE_COMBINER_CLASS.get(conf);
        this.vertexResolverClass = VERTEX_RESOLVER_CLASS.get(conf);
        this.vertexValueCombinerClass = VERTEX_VALUE_COMBINER_CLASS.get(conf);
        this.workerContextClass = WORKER_CONTEXT_CLASS.get(conf);
        this.masterComputeClass = MASTER_COMPUTE_CLASS.get(conf);
        this.partitionClass = PARTITION_CLASS.get(conf);
        this.edgeInputFilterClass = EDGE_INPUT_FILTER_CLASS.get(conf);
        this.vertexInputFilterClass = VERTEX_INPUT_FILTER_CLASS.get(conf);
    }

    public Class<? extends ComputationFactory<I, V, E, ? extends Writable, ? extends Writable>> getComputationFactoryClass() {
        return this.computationFactoryClass;
    }

    public Class<? extends Computation<I, V, E, ? extends Writable, ? extends Writable>> getComputationClass() {
        return this.computationClass;
    }

    public GiraphTypes<I, V, E> getGiraphTypes() {
        return this.giraphTypes;
    }

    public Class<I> getVertexIdClass() {
        return this.giraphTypes.getVertexIdClass();
    }

    public Class<? extends Vertex> getVertexClass() {
        return this.giraphTypes.getVertexClass();
    }

    public Class<V> getVertexValueClass() {
        return this.giraphTypes.getVertexValueClass();
    }

    public Class<E> getEdgeValueClass() {
        return this.giraphTypes.getEdgeValueClass();
    }

    public Class<? extends Writable> getIncomingMessageValueClass() {
        return this.giraphTypes.getIncomingMessageValueClass();
    }

    public Class<? extends Writable> getOutgoingMessageValueClass() {
        return this.giraphTypes.getOutgoingMessageValueClass();
    }

    public Class<? extends OutEdges<I, E>> getOutEdgesClass() {
        return this.outEdgesClass;
    }

    public Class<? extends OutEdges<I, E>> getInputOutEdgesClass() {
        return this.inputOutEdgesClass;
    }

    public Class<? extends GraphPartitionerFactory<I, V, E>> getGraphPartitionerFactoryClass() {
        return this.graphPartitionerFactoryClass;
    }

    public Class<? extends EdgeInputFilter<I, E>> getEdgeInputFilterClass() {
        return this.edgeInputFilterClass;
    }

    public Class<? extends VertexInputFilter<I, V, E>> getVertexInputFilterClass() {
        return this.vertexInputFilterClass;
    }

    public boolean hasVertexInputFormat() {
        return this.vertexInputFormatClass != null;
    }

    public Class<? extends VertexInputFormat<I, V, E>> getVertexInputFormatClass() {
        return this.vertexInputFormatClass;
    }

    public boolean hasVertexOutputFormat() {
        return this.vertexOutputFormatClass != null;
    }

    public boolean hasMappingInputFormat() {
        return this.mappingInputFormatClass != null;
    }

    public Class<? extends VertexOutputFormat<I, V, E>> getVertexOutputFormatClass() {
        return this.vertexOutputFormatClass;
    }

    public Class<? extends MappingInputFormat<I, V, E, ? extends Writable>> getMappingInputFormatClass() {
        return this.mappingInputFormatClass;
    }

    public boolean hasEdgeInputFormat() {
        return this.edgeInputFormatClass != null;
    }

    public Class<? extends EdgeInputFormat<I, E>> getEdgeInputFormatClass() {
        return this.edgeInputFormatClass;
    }

    public boolean hasEdgeOutputFormat() {
        return this.edgeOutputFormatClass != null;
    }

    public Class<? extends EdgeOutputFormat<I, V, E>> getEdgeOutputFormatClass() {
        return this.edgeOutputFormatClass;
    }

    public boolean hasAggregatorWriterClass() {
        return this.aggregatorWriterClass != null;
    }

    public Class<? extends AggregatorWriter> getAggregatorWriterClass() {
        return this.aggregatorWriterClass;
    }

    public boolean hasMessageCombinerClass() {
        return this.messageCombinerClass != null;
    }

    public Class<? extends MessageCombiner<I, ? extends Writable>> getMessageCombinerClass() {
        return this.messageCombinerClass;
    }

    public boolean hasVertexResolverClass() {
        return this.vertexResolverClass != null;
    }

    public Class<? extends VertexResolver<I, V, E>> getVertexResolverClass() {
        return this.vertexResolverClass;
    }

    public Class<? extends VertexValueCombiner<V>> getVertexValueCombinerClass() {
        return this.vertexValueCombinerClass;
    }

    public boolean hasWorkerContextClass() {
        return this.workerContextClass != null;
    }

    public Class<? extends WorkerContext> getWorkerContextClass() {
        return this.workerContextClass;
    }

    public boolean hasMasterComputeClass() {
        return this.masterComputeClass != null;
    }

    public Class<? extends MasterCompute> getMasterComputeClass() {
        return this.masterComputeClass;
    }

    public boolean hasPartitionClass() {
        return this.partitionClass != null;
    }

    public Class<? extends Partition<I, V, E>> getPartitionClass() {
        return this.partitionClass;
    }

    public GiraphClasses setComputationClass(Class<? extends Computation<I, V, E, ? extends Writable, ? extends Writable>> computationClass) {
        this.computationClass = computationClass;
        return this;
    }

    public GiraphClasses setVertexIdClass(Class<I> vertexIdClass) {
        this.giraphTypes.setVertexIdClass(vertexIdClass);
        return this;
    }

    public GiraphClasses setVertexValueClass(Class<V> vertexValueClass) {
        this.giraphTypes.setVertexValueClass(vertexValueClass);
        return this;
    }

    public GiraphClasses setEdgeValueClass(Class<E> edgeValueClass) {
        this.giraphTypes.setEdgeValueClass(edgeValueClass);
        return this;
    }

    public GiraphClasses setIncomingMessageValueClass(Class<? extends Writable> incomingMessageValueClass) {
        this.giraphTypes.setIncomingMessageValueClass(incomingMessageValueClass);
        return this;
    }

    public GiraphClasses setOutgoingMessageValueClass(Class<? extends Writable> outgoingMessageValueClass) {
        this.giraphTypes.setOutgoingMessageValueClass(outgoingMessageValueClass);
        return this;
    }

    public GiraphClasses setOutEdgesClass(Class<? extends OutEdges> outEdgesClass) {
        this.outEdgesClass = outEdgesClass;
        return this;
    }

    public GiraphClasses setInputOutEdgesClass(Class<? extends OutEdges> inputOutEdgesClass) {
        this.inputOutEdgesClass = inputOutEdgesClass;
        return this;
    }

    public GiraphClasses setGraphPartitionerFactoryClass(Class<? extends GraphPartitionerFactory<I, V, E>> klass) {
        this.graphPartitionerFactoryClass = klass;
        return this;
    }

    public GiraphClasses setVertexInputFormatClass(Class<? extends VertexInputFormat<I, V, E>> vertexInputFormatClass) {
        this.vertexInputFormatClass = vertexInputFormatClass;
        return this;
    }

    public GiraphClasses setVertexOutputFormatClass(Class<? extends VertexOutputFormat<I, V, E>> vertexOutputFormatClass) {
        this.vertexOutputFormatClass = vertexOutputFormatClass;
        return this;
    }

    public GiraphClasses setEdgeInputFormatClass(Class<? extends EdgeInputFormat<I, E>> edgeInputFormatClass) {
        this.edgeInputFormatClass = edgeInputFormatClass;
        return this;
    }

    public GiraphClasses setAggregatorWriterClass(Class<? extends AggregatorWriter> aggregatorWriterClass) {
        this.aggregatorWriterClass = aggregatorWriterClass;
        return this;
    }

    public GiraphClasses setMessageCombiner(Class<? extends MessageCombiner<I, ? extends Writable>> combinerClass) {
        this.messageCombinerClass = combinerClass;
        return this;
    }

    public GiraphClasses setVertexResolverClass(Class<? extends VertexResolver<I, V, E>> vertexResolverClass) {
        this.vertexResolverClass = vertexResolverClass;
        return this;
    }

    public GiraphClasses setWorkerContextClass(Class<? extends WorkerContext> workerContextClass) {
        this.workerContextClass = workerContextClass;
        return this;
    }

    public GiraphClasses setMasterComputeClass(Class<? extends MasterCompute> masterComputeClass) {
        this.masterComputeClass = masterComputeClass;
        return this;
    }

    public GiraphClasses setPartitionClass(Class<? extends Partition<I, V, E>> partitionClass) {
        this.partitionClass = partitionClass;
        return this;
    }
}

