/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import org.apache.giraph.conf.AbstractConfOption;
import org.apache.giraph.conf.AllOptions;
import org.apache.giraph.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;

public class FloatConfOption
extends AbstractConfOption {
    private final float defaultValue;

    public FloatConfOption(String key, float defaultValue, String description) {
        super(key, description);
        this.defaultValue = defaultValue;
        AllOptions.add(this);
    }

    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public boolean isDefaultValue(Configuration conf) {
        return Float.compare(this.get(conf), this.defaultValue) == 0;
    }

    @Override
    public String getDefaultValueStr() {
        return Float.toString(this.defaultValue);
    }

    @Override
    public ConfOptionType getType() {
        return ConfOptionType.FLOAT;
    }

    public float get(Configuration conf) {
        return conf.getFloat(this.getKey(), this.defaultValue);
    }

    public void set(Configuration conf, float value) {
        conf.setFloat(this.getKey(), value);
    }

    public void setIfUnset(Configuration conf, float value) {
        if (!this.contains(conf)) {
            conf.setFloat(this.getKey(), value);
        }
    }
}

