/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import com.google.common.base.Objects;
import org.apache.giraph.conf.AbstractConfOption;
import org.apache.giraph.conf.AllOptions;
import org.apache.giraph.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;

public class EnumConfOption<T extends Enum<T>>
extends AbstractConfOption {
    private final Class<T> klass;
    private final T defaultValue;

    public EnumConfOption(String key, Class<T> klass, T defaultValue, String description) {
        super(key, description);
        this.klass = klass;
        this.defaultValue = defaultValue;
        AllOptions.add(this);
    }

    public static <X extends Enum<X>> EnumConfOption<X> create(String key, Class<X> klass, X defaultValue, String description) {
        return new EnumConfOption<X>(key, klass, defaultValue, description);
    }

    @Override
    public boolean isDefaultValue(Configuration conf) {
        return Objects.equal(this.get(conf), this.defaultValue);
    }

    @Override
    public String getDefaultValueStr() {
        return ((Enum)this.defaultValue).name();
    }

    @Override
    public ConfOptionType getType() {
        return ConfOptionType.ENUM;
    }

    public T get(Configuration conf) {
        String valueStr = conf.get(this.getKey(), this.getDefaultValueStr());
        return Enum.valueOf(this.klass, valueStr);
    }

    public void set(Configuration conf, Enum<T> value) {
        conf.set(this.getKey(), value.name());
    }

    public void setIfUnset(Configuration conf, Enum<T> value) {
        if (!this.contains(conf)) {
            this.set(conf, value);
        }
    }
}

