/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.giraph.conf.AbstractConfOption;
import org.apache.giraph.conf.ConfOptionType;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.log4j.Logger;

public class AllOptions {
    private static final Logger LOG = Logger.getLogger(AllOptions.class);
    private static final List<AbstractConfOption> CONF_OPTIONS = Lists.newArrayList();
    private static final String PAGE_NAME = "Giraph Options";

    private AllOptions() {
    }

    public static void add(AbstractConfOption confOption) {
        CONF_OPTIONS.add(confOption);
    }

    public static String allOptionsString() {
        Collections.sort(CONF_OPTIONS);
        StringBuilder sb = new StringBuilder(CONF_OPTIONS.size() * 30);
        sb.append("All Options:\n");
        ConfOptionType lastType = null;
        for (AbstractConfOption confOption : CONF_OPTIONS) {
            if (!confOption.getType().equals((Object)lastType)) {
                sb.append(confOption.getType().toString().toLowerCase()).append(":\n");
                lastType = confOption.getType();
            }
            sb.append(confOption);
        }
        return sb.toString();
    }

    public static String allOptionsHTMLString() {
        Collections.sort(CONF_OPTIONS);
        StringBuilder sb = new StringBuilder(CONF_OPTIONS.size() * 30);
        sb.append("<?xml version='1.0' encoding='UTF-8'?>\n<!--\nLicensed to the Apache Software Foundation (ASF) under one\nor more contributor license agreements.  See the NOTICE file\ndistributed with this work for additional information\nregarding copyright ownership.  The ASF licenses this file\nto you under the Apache License, Version 2.0 (the\n'License'); you may not use this file except in compliance\nwith the License.  You may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing,\nsoftware distributed under the License is distributed on an\n'AS IS' BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY\nKIND, either express or implied.  See the License for the\nspecific language governing permissions and limitations\nunder the License.\n-->\n\n<document xmlns='http://maven.apache.org/XDOC/2.0'\n          xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\n          xsi:schemaLocation='http://maven.apache.org/XDOC/2.0  http://maven.apache.org/xsd/xdoc-2.0.xsd'>\n  <properties>\n    <title>Giraph Options</title>\n  </properties>\n  <body>\n    <section name='Giraph Options'>\n      <table border='0' style='width:110%; max-width:110%'>\n       <tr>\n        <th>label</th>\n        <th>type</th>\n        <th>default value</th>\n        <th>description</th>\n       </tr>\n");
        for (AbstractConfOption confOption : CONF_OPTIONS) {
            String type = confOption.getType().toString().toLowerCase();
            sb.append("       <tr>\n");
            sb.append("         <td>" + confOption.getKey() + "</td>\n");
            sb.append("         <td>" + type + "</td>\n");
            sb.append("         <td>" + confOption.getDefaultValueStr() + "</td>\n");
            sb.append("         <td>" + confOption.getDescription() + "</td>\n");
            sb.append("       </tr>\n");
        }
        sb.append("      </table>\n    </section>\n  </body>\n</document>\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        GiraphConstants.COMPUTATION_CLASS.toString();
        if (args.length == 1) {
            String html = AllOptions.allOptionsHTMLString();
            try {
                FileWriter fs = new FileWriter(args[0]);
                BufferedWriter out = new BufferedWriter(fs);
                out.write(html);
                out.close();
            }
            catch (IOException e) {
                LOG.error((Object)("Error: " + e.getMessage()));
            }
        }
        LOG.info((Object)AllOptions.allOptionsString());
    }
}

