/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.conf;

import com.google.common.base.Objects;
import com.google.common.collect.ComparisonChain;
import org.apache.giraph.conf.ConfOptionType;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public abstract class AbstractConfOption
implements Comparable<AbstractConfOption> {
    private static final Logger LOG = Logger.getLogger(AbstractConfOption.class);
    private final String key;
    private final String description;

    public AbstractConfOption(String key, String description) {
        this.key = key;
        this.description = description;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean contains(Configuration conf) {
        return conf.get(this.key) != null;
    }

    @Override
    public int compareTo(AbstractConfOption o) {
        return ComparisonChain.start().compare((Comparable)((Object)this.getType()), (Comparable)((Object)o.getType())).compare((Comparable)((Object)this.key), (Comparable)((Object)o.key)).result();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractConfOption)) {
            return false;
        }
        AbstractConfOption that = (AbstractConfOption)o;
        return Objects.equal((Object)((Object)this.getType()), (Object)((Object)that.getType())) && Objects.equal((Object)this.key, (Object)that.key);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append("  ").append(this.key).append(" => ").append(this.getDefaultValueStr());
        sb.append(" (").append(this.getType().toString().toLowerCase()).append(")\n");
        return sb.toString();
    }

    public abstract boolean isDefaultValue(Configuration var1);

    public abstract String getDefaultValueStr();

    public abstract ConfOptionType getType();
}

