/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.conf.ImmutableClassesGiraphConfigurable;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public abstract class WritableRequest<I extends WritableComparable, V extends Writable, E extends Writable>
implements Writable,
ImmutableClassesGiraphConfigurable<I, V, E> {
    public static final int UNKNOWN_SIZE = -1;
    protected ImmutableClassesGiraphConfiguration<I, V, E> conf;
    private int clientId = -1;
    private long requestId = -1L;

    public int getClientId() {
        return this.clientId;
    }

    public void setClientId(int clientId) {
        this.clientId = clientId;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    public int getSerializedSize() {
        return 12;
    }

    public abstract RequestType getType();

    abstract void readFieldsRequest(DataInput var1) throws IOException;

    abstract void writeRequest(DataOutput var1) throws IOException;

    @Override
    public final ImmutableClassesGiraphConfiguration<I, V, E> getConf() {
        return this.conf;
    }

    @Override
    public final void setConf(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        this.conf = conf;
    }

    public final void readFields(DataInput input) throws IOException {
        this.clientId = input.readInt();
        this.requestId = input.readLong();
        this.readFieldsRequest(input);
    }

    public final void write(DataOutput output) throws IOException {
        output.writeInt(this.clientId);
        output.writeLong(this.requestId);
        this.writeRequest(output);
    }
}

