/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WorkerRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionStore;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.PairList;
import org.apache.giraph.utils.VertexIterator;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class SendWorkerVerticesRequest<I extends WritableComparable, V extends Writable, E extends Writable>
extends WritableRequest<I, V, E>
implements WorkerRequest<I, V, E> {
    private static final Logger LOG = Logger.getLogger(SendWorkerVerticesRequest.class);
    private PairList<Integer, ExtendedDataOutput> workerPartitions;

    public SendWorkerVerticesRequest() {
    }

    public SendWorkerVerticesRequest(ImmutableClassesGiraphConfiguration<I, V, E> conf, PairList<Integer, ExtendedDataOutput> workerPartitions) {
        this.workerPartitions = workerPartitions;
        this.setConf(conf);
    }

    @Override
    public void readFieldsRequest(DataInput input) throws IOException {
        int numPartitions = input.readInt();
        this.workerPartitions = new PairList();
        this.workerPartitions.initialize(numPartitions);
        while (numPartitions-- > 0) {
            int partitionId = input.readInt();
            ExtendedDataOutput partitionData = WritableUtils.readExtendedDataOutput(input, this.getConf());
            this.workerPartitions.add(partitionId, partitionData);
        }
    }

    @Override
    public void writeRequest(DataOutput output) throws IOException {
        output.writeInt(this.workerPartitions.getSize());
        PairList.Iterator iterator = this.workerPartitions.getIterator();
        while (iterator.hasNext()) {
            iterator.next();
            output.writeInt((Integer)iterator.getCurrentFirst());
            WritableUtils.writeExtendedDataOutput((ExtendedDataOutput)iterator.getCurrentSecond(), output);
        }
    }

    @Override
    public RequestType getType() {
        return RequestType.SEND_WORKER_VERTICES_REQUEST;
    }

    @Override
    public void doRequest(ServerData<I, V, E> serverData) {
        PairList.Iterator iterator = this.workerPartitions.getIterator();
        while (iterator.hasNext()) {
            iterator.next();
            VertexIterator vertexIterator = new VertexIterator((ExtendedDataOutput)iterator.getCurrentSecond(), this.getConf());
            PartitionStore<I, V, E> store = serverData.getPartitionStore();
            Partition partition = store.getOrCreatePartition((Integer)iterator.getCurrentFirst());
            partition.addPartitionVertices(vertexIterator);
            store.putPartition(partition);
        }
    }

    @Override
    public int getSerializedSize() {
        int size = super.getSerializedSize() + 4;
        PairList.Iterator iterator = this.workerPartitions.getIterator();
        while (iterator.hasNext()) {
            iterator.next();
            size += 8 + ((ExtendedDataOutput)iterator.getCurrentSecond()).getPos();
        }
        return size;
    }
}

