/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WorkerRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class SendWorkerToWorkerMessageRequest
extends WritableRequest
implements WorkerRequest<WritableComparable, Writable, Writable> {
    private Writable message;

    public SendWorkerToWorkerMessageRequest() {
    }

    public SendWorkerToWorkerMessageRequest(Writable message) {
        this.message = message;
    }

    @Override
    public RequestType getType() {
        return RequestType.SEND_WORKER_TO_WORKER_MESSAGE_REQUEST;
    }

    @Override
    void writeRequest(DataOutput output) throws IOException {
        Text.writeString((DataOutput)output, (String)this.message.getClass().getName());
        this.message.write(output);
    }

    @Override
    void readFieldsRequest(DataInput input) throws IOException {
        String className = Text.readString((DataInput)input);
        try {
            this.message = (Writable)Class.forName(className).newInstance();
            this.message.readFields(input);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("readFieldsRequest: Exception occurred", e);
        }
    }

    @Override
    public void doRequest(ServerData<WritableComparable, Writable, Writable> serverData) {
        serverData.addIncomingWorkerToWorkerMessage(this.message);
    }
}

