/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WorkerRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.utils.ByteArrayOneMessageToManyIds;
import org.apache.giraph.utils.ByteArrayVertexIdMessages;
import org.apache.giraph.utils.VertexIdMessageIterator;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class SendWorkerOneMessageToManyRequest<I extends WritableComparable, M extends Writable>
extends WritableRequest<I, Writable, Writable>
implements WorkerRequest<I, Writable, Writable> {
    protected ByteArrayOneMessageToManyIds<I, M> oneMessageToManyIds;

    public SendWorkerOneMessageToManyRequest() {
    }

    public SendWorkerOneMessageToManyRequest(ByteArrayOneMessageToManyIds<I, M> oneMessageToManyIds, ImmutableClassesGiraphConfiguration conf) {
        this.oneMessageToManyIds = oneMessageToManyIds;
        this.setConf(conf);
    }

    @Override
    public RequestType getType() {
        return RequestType.SEND_WORKER_ONE_MESSAGE_TO_MANY_REQUEST;
    }

    @Override
    public void readFieldsRequest(DataInput input) throws IOException {
        this.oneMessageToManyIds = new ByteArrayOneMessageToManyIds(this.getConf().getOutgoingMessageValueFactory());
        this.oneMessageToManyIds.setConf(this.getConf());
        this.oneMessageToManyIds.readFields(input);
    }

    @Override
    public void writeRequest(DataOutput output) throws IOException {
        this.oneMessageToManyIds.write(output);
    }

    @Override
    public int getSerializedSize() {
        return super.getSerializedSize() + this.oneMessageToManyIds.getSerializedSize();
    }

    @Override
    public void doRequest(ServerData serverData) {
        try {
            MessageStore<I, M> messageStore = serverData.getIncomingMessageStore();
            if (messageStore.isPointerListEncoding()) {
                messageStore.addPartitionMessages(-1, this.oneMessageToManyIds);
            } else {
                CentralizedServiceWorker serviceWorker = serverData.getServiceWorker();
                int initialSize = this.oneMessageToManyIds.getSize() / serverData.getPartitionStore().getNumPartitions() * 2;
                Int2ObjectOpenHashMap partitionIdMsgs = new Int2ObjectOpenHashMap();
                VertexIdMessageIterator<I, M> vertexIdMessageIterator = this.oneMessageToManyIds.getVertexIdMessageIterator();
                while (vertexIdMessageIterator.hasNext()) {
                    vertexIdMessageIterator.next();
                    M msg = vertexIdMessageIterator.getCurrentMessage();
                    Object vertexId = vertexIdMessageIterator.getCurrentVertexId();
                    PartitionOwner owner = serviceWorker.getVertexPartitionOwner(vertexId);
                    int partitionId = owner.getPartitionId();
                    ByteArrayVertexIdMessages idMsgs = (ByteArrayVertexIdMessages)partitionIdMsgs.get(partitionId);
                    if (idMsgs == null) {
                        idMsgs = new ByteArrayVertexIdMessages(this.getConf().getOutgoingMessageValueFactory());
                        idMsgs.setConf(this.getConf());
                        idMsgs.initialize(initialSize);
                        partitionIdMsgs.put(partitionId, idMsgs);
                    }
                    idMsgs.add(vertexId, msg);
                }
                for (Map.Entry idMsgs : partitionIdMsgs.entrySet()) {
                    if (((ByteArrayVertexIdMessages)idMsgs.getValue()).isEmpty()) continue;
                    serverData.getIncomingMessageStore().addPartitionMessages((Integer)idMsgs.getKey(), (VertexIdMessages)idMsgs.getValue());
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("doRequest: Got IOException ", e);
        }
    }
}

