/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import java.io.IOException;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.SendWorkerDataRequest;
import org.apache.giraph.utils.ByteArrayVertexIdMessages;
import org.apache.giraph.utils.PairList;
import org.apache.giraph.utils.VertexIdMessages;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class SendWorkerMessagesRequest<I extends WritableComparable, M extends Writable>
extends SendWorkerDataRequest<I, M, VertexIdMessages<I, M>> {
    public SendWorkerMessagesRequest() {
    }

    public SendWorkerMessagesRequest(PairList<Integer, VertexIdMessages<I, M>> partVertMsgs) {
        this.partitionVertexData = partVertMsgs;
    }

    @Override
    public VertexIdMessages<I, M> createVertexIdData() {
        return new ByteArrayVertexIdMessages(this.getConf().getOutgoingMessageValueFactory());
    }

    @Override
    public RequestType getType() {
        return RequestType.SEND_WORKER_MESSAGES_REQUEST;
    }

    public void doRequest(ServerData serverData) {
        PairList.Iterator iterator = this.partitionVertexData.getIterator();
        while (iterator.hasNext()) {
            iterator.next();
            try {
                serverData.getIncomingMessageStore().addPartitionMessages((Integer)iterator.getCurrentFirst(), (VertexIdMessages)iterator.getCurrentSecond());
            }
            catch (IOException e) {
                throw new RuntimeException("doRequest: Got IOException ", e);
            }
        }
    }
}

