/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.SendWorkerDataRequest;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.utils.ByteArrayVertexIdEdges;
import org.apache.giraph.utils.PairList;
import org.apache.giraph.utils.VertexIdEdges;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class SendWorkerEdgesRequest<I extends WritableComparable, E extends Writable>
extends SendWorkerDataRequest<I, Edge<I, E>, VertexIdEdges<I, E>> {
    public SendWorkerEdgesRequest() {
    }

    public SendWorkerEdgesRequest(PairList<Integer, VertexIdEdges<I, E>> partVertEdges) {
        this.partitionVertexData = partVertEdges;
    }

    @Override
    public VertexIdEdges<I, E> createVertexIdData() {
        return new ByteArrayVertexIdEdges();
    }

    @Override
    public RequestType getType() {
        return RequestType.SEND_WORKER_EDGES_REQUEST;
    }

    public void doRequest(ServerData serverData) {
        PairList.Iterator iterator = this.partitionVertexData.getIterator();
        while (iterator.hasNext()) {
            iterator.next();
            serverData.getEdgeStore().addPartitionEdges((Integer)iterator.getCurrentFirst(), (VertexIdEdges)iterator.getCurrentSecond());
        }
    }
}

