/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.comm.requests.WorkerRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.utils.PairList;
import org.apache.giraph.utils.VertexIdData;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public abstract class SendWorkerDataRequest<I extends WritableComparable, T, B extends VertexIdData<I, T>>
extends WritableRequest
implements WorkerRequest {
    private static final Logger LOG = Logger.getLogger(SendWorkerDataRequest.class);
    protected PairList<Integer, B> partitionVertexData;

    public SendWorkerDataRequest() {
    }

    public SendWorkerDataRequest(PairList<Integer, B> partVertData) {
        this.partitionVertexData = partVertData;
    }

    public abstract B createVertexIdData();

    @Override
    public void readFieldsRequest(DataInput input) throws IOException {
        int numPartitions = input.readInt();
        this.partitionVertexData = new PairList();
        this.partitionVertexData.initialize(numPartitions);
        while (numPartitions-- > 0) {
            int partitionId = input.readInt();
            B vertexIdData = this.createVertexIdData();
            vertexIdData.setConf(this.getConf());
            vertexIdData.readFields(input);
            this.partitionVertexData.add(partitionId, vertexIdData);
        }
    }

    @Override
    public void writeRequest(DataOutput output) throws IOException {
        output.writeInt(this.partitionVertexData.getSize());
        PairList.Iterator iterator = this.partitionVertexData.getIterator();
        while (iterator.hasNext()) {
            iterator.next();
            output.writeInt((Integer)iterator.getCurrentFirst());
            ((VertexIdData)iterator.getCurrentSecond()).write(output);
        }
    }

    @Override
    public int getSerializedSize() {
        int size = super.getSerializedSize() + 4;
        PairList.Iterator iterator = this.partitionVertexData.getIterator();
        while (iterator.hasNext()) {
            iterator.next();
            size += 4 + ((VertexIdData)iterator.getCurrentSecond()).getSerializedSize();
        }
        return size;
    }
}

