/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import java.io.DataInput;
import java.io.IOException;
import org.apache.giraph.comm.GlobalCommType;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.aggregators.OwnerAggregatorServerData;
import org.apache.giraph.comm.requests.ByteArrayWithSenderTaskIdRequest;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WorkerRequest;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public class SendWorkerAggregatorsRequest
extends ByteArrayWithSenderTaskIdRequest
implements WorkerRequest {
    public SendWorkerAggregatorsRequest(byte[] data, int senderTaskId) {
        super(data, senderTaskId);
    }

    public SendWorkerAggregatorsRequest() {
    }

    public void doRequest(ServerData serverData) {
        DataInput input = this.getDataInput();
        OwnerAggregatorServerData aggregatorData = serverData.getOwnerAggregatorData();
        try {
            int num = input.readInt();
            for (int i = 0; i < num; ++i) {
                LongWritable value;
                String name = input.readUTF();
                GlobalCommType type = GlobalCommType.values()[input.readByte()];
                if (type == GlobalCommType.SPECIAL_COUNT) {
                    value = new LongWritable();
                    value.readFields(input);
                    aggregatorData.receivedRequestCountFromWorker(value.get(), this.getSenderTaskId());
                    continue;
                }
                if (type == GlobalCommType.REDUCED_VALUE) {
                    value = aggregatorData.createInitialValue(name);
                    value.readFields(input);
                    aggregatorData.reduce(name, (Writable)value);
                    continue;
                }
                throw new IllegalStateException("SendWorkerAggregatorsRequest received " + (Object)((Object)type));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("doRequest: IOException occurred while processing request", e);
        }
        aggregatorData.receivedRequestFromWorker();
    }

    @Override
    public RequestType getType() {
        return RequestType.SEND_WORKER_AGGREGATORS_REQUEST;
    }
}

