/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WorkerRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.partition.Partition;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class SendVertexRequest<I extends WritableComparable, V extends Writable, E extends Writable>
extends WritableRequest<I, V, E>
implements WorkerRequest<I, V, E> {
    private static final Logger LOG = Logger.getLogger(SendVertexRequest.class);
    private Partition<I, V, E> partition;

    public SendVertexRequest() {
    }

    public SendVertexRequest(Partition<I, V, E> partition) {
        this.partition = partition;
    }

    @Override
    public void readFieldsRequest(DataInput input) throws IOException {
        this.partition = this.getConf().createPartition(-1, null);
        this.partition.readFields(input);
    }

    @Override
    public void writeRequest(DataOutput output) throws IOException {
        this.partition.write(output);
    }

    @Override
    public RequestType getType() {
        return RequestType.SEND_VERTEX_REQUEST;
    }

    @Override
    public void doRequest(ServerData<I, V, E> serverData) {
        serverData.getPartitionStore().addPartition(this.partition);
    }

    @Override
    public int getSerializedSize() {
        return -1;
    }
}

