/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import com.google.common.collect.Maps;
import com.yammer.metrics.core.Histogram;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WorkerRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.graph.VertexMutations;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class SendPartitionMutationsRequest<I extends WritableComparable, V extends Writable, E extends Writable>
extends WritableRequest<I, V, E>
implements WorkerRequest<I, V, E> {
    private static final Logger LOG = Logger.getLogger(SendPartitionMutationsRequest.class);
    private int partitionId;
    private Map<I, VertexMutations<I, V, E>> vertexIdMutations;

    public SendPartitionMutationsRequest() {
    }

    public SendPartitionMutationsRequest(int partitionId, Map<I, VertexMutations<I, V, E>> vertexIdMutations) {
        this.partitionId = partitionId;
        this.vertexIdMutations = vertexIdMutations;
    }

    @Override
    public void readFieldsRequest(DataInput input) throws IOException {
        this.partitionId = input.readInt();
        int vertexIdMutationsSize = input.readInt();
        this.vertexIdMutations = Maps.newHashMapWithExpectedSize((int)vertexIdMutationsSize);
        for (int i = 0; i < vertexIdMutationsSize; ++i) {
            Object vertexId = this.getConf().createVertexId();
            vertexId.readFields(input);
            VertexMutations vertexMutations = new VertexMutations();
            vertexMutations.setConf(this.getConf());
            vertexMutations.readFields(input);
            if (this.vertexIdMutations.put(vertexId, vertexMutations) == null) continue;
            throw new IllegalStateException("readFields: Already has vertex id " + vertexId);
        }
    }

    @Override
    public void writeRequest(DataOutput output) throws IOException {
        output.writeInt(this.partitionId);
        output.writeInt(this.vertexIdMutations.size());
        for (Map.Entry<I, VertexMutations<I, V, E>> entry : this.vertexIdMutations.entrySet()) {
            ((WritableComparable)entry.getKey()).write(output);
            entry.getValue().write(output);
        }
    }

    @Override
    public RequestType getType() {
        return RequestType.SEND_PARTITION_MUTATIONS_REQUEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRequest(ServerData<I, V, E> serverData) {
        ConcurrentHashMap<I, VertexMutations<I, VertexMutations<I, V, E>, E>> vertexMutations = serverData.getVertexMutations();
        Histogram verticesInMutationHist = GiraphMetrics.get().perSuperstep().getUniformHistogram("vertices-per-mutations-request");
        verticesInMutationHist.update(vertexMutations.size());
        for (Map.Entry<I, VertexMutations<I, V, E>> entry : this.vertexIdMutations.entrySet()) {
            VertexMutations<I, V, E> mutations = vertexMutations.get(entry.getKey());
            if (mutations == null && (mutations = vertexMutations.putIfAbsent(entry.getKey(), entry.getValue())) == null) continue;
            VertexMutations<I, V, E> vertexMutations2 = mutations;
            synchronized (vertexMutations2) {
                mutations.addVertexMutations(entry.getValue());
            }
        }
    }

    @Override
    public int getSerializedSize() {
        return -1;
    }
}

