/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WorkerRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.utils.ByteArrayVertexIdMessages;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;

public class SendPartitionCurrentMessagesRequest<I extends WritableComparable, V extends Writable, E extends Writable, M extends Writable>
extends WritableRequest<I, V, E>
implements WorkerRequest<I, V, E> {
    private int partitionId;
    private ByteArrayVertexIdMessages<I, M> vertexIdMessageMap;

    public SendPartitionCurrentMessagesRequest() {
    }

    public SendPartitionCurrentMessagesRequest(int partitionId, ByteArrayVertexIdMessages<I, M> vertexIdMessages) {
        this.partitionId = partitionId;
        this.vertexIdMessageMap = vertexIdMessages;
    }

    @Override
    public RequestType getType() {
        return RequestType.SEND_PARTITION_CURRENT_MESSAGES_REQUEST;
    }

    @Override
    public void readFieldsRequest(DataInput input) throws IOException {
        this.partitionId = input.readInt();
        this.vertexIdMessageMap = new ByteArrayVertexIdMessages(this.getConf().getIncomingMessageValueFactory());
        this.vertexIdMessageMap.setConf(this.getConf());
        this.vertexIdMessageMap.initialize();
        this.vertexIdMessageMap.readFields(input);
    }

    @Override
    public void writeRequest(DataOutput output) throws IOException {
        output.writeInt(this.partitionId);
        this.vertexIdMessageMap.write(output);
    }

    @Override
    public void doRequest(ServerData<I, V, E> serverData) {
        try {
            serverData.getCurrentMessageStore().addPartitionMessages(this.partitionId, this.vertexIdMessageMap);
        }
        catch (IOException e) {
            throw new RuntimeException("doRequest: Got IOException ", e);
        }
    }

    @Override
    public int getSerializedSize() {
        return super.getSerializedSize() + 4 + this.vertexIdMessageMap.getSerializedSize();
    }
}

