/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import java.io.DataInput;
import java.io.IOException;
import org.apache.giraph.comm.GlobalCommType;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.aggregators.AllAggregatorServerData;
import org.apache.giraph.comm.requests.ByteArrayWithSenderTaskIdRequest;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WorkerRequest;
import org.apache.giraph.utils.WritableUtils;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Writable;

public class SendAggregatorsToWorkerRequest
extends ByteArrayWithSenderTaskIdRequest
implements WorkerRequest {
    public SendAggregatorsToWorkerRequest(byte[] data, int senderTaskId) {
        super(data, senderTaskId);
    }

    public SendAggregatorsToWorkerRequest() {
    }

    public void doRequest(ServerData serverData) {
        DataInput input = this.getDataInput();
        AllAggregatorServerData aggregatorData = serverData.getAllAggregatorData();
        try {
            int num = input.readInt();
            for (int i = 0; i < num; ++i) {
                String name = input.readUTF();
                GlobalCommType type = GlobalCommType.values()[input.readByte()];
                Object value = WritableUtils.readWritableObject(input, this.conf);
                if (type == GlobalCommType.SPECIAL_COUNT) {
                    aggregatorData.receivedRequestCountFromWorker(((LongWritable)value).get(), this.getSenderTaskId());
                    continue;
                }
                aggregatorData.receiveValueFromMaster(name, type, (Writable)value);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("doRequest: IOException occurred while processing request", e);
        }
        aggregatorData.receivedRequestFromWorker();
    }

    @Override
    public RequestType getType() {
        return RequestType.SEND_AGGREGATORS_TO_WORKER_REQUEST;
    }
}

