/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.comm.netty.SaslNettyServer;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.log4j.Logger;

public class SaslTokenMessageRequest
extends WritableRequest {
    private static final Logger LOG = Logger.getLogger(SaslTokenMessageRequest.class);
    private byte[] token;

    public SaslTokenMessageRequest() {
    }

    public SaslTokenMessageRequest(byte[] token) {
        this.token = token;
    }

    public byte[] getSaslToken() {
        return this.token;
    }

    public void setSaslToken(byte[] token) {
        this.token = token;
    }

    @Override
    public RequestType getType() {
        return RequestType.SASL_TOKEN_MESSAGE_REQUEST;
    }

    @Override
    public void readFieldsRequest(DataInput input) throws IOException {
        int tokenSize = input.readInt();
        this.token = new byte[tokenSize];
        input.readFully(this.token);
    }

    public void processToken(SaslNettyServer saslNettyServer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("processToken:  With nettyServer: " + (Object)((Object)saslNettyServer) + " and token length: " + this.token.length));
        }
        this.token = saslNettyServer.response(this.token);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("processToken: Response token's length is:" + this.token.length));
        }
    }

    @Override
    public void writeRequest(DataOutput output) throws IOException {
        output.writeInt(this.token.length);
        output.write(this.token);
    }

    @Override
    public int getSerializedSize() {
        return super.getSerializedSize() + 4 + this.token.length;
    }
}

