/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.requests;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.giraph.comm.requests.WritableRequest;

public abstract class ByteArrayRequest
extends WritableRequest {
    private byte[] data;

    ByteArrayRequest(byte[] data) {
        this.data = data;
    }

    ByteArrayRequest() {
    }

    public byte[] getData() {
        return this.data;
    }

    public DataInput getDataInput() {
        return new DataInputStream(new ByteArrayInputStream(this.data));
    }

    @Override
    void readFieldsRequest(DataInput input) throws IOException {
        int dataLength = input.readInt();
        this.data = new byte[dataLength];
        input.readFully(this.data);
    }

    @Override
    void writeRequest(DataOutput output) throws IOException {
        output.writeInt(this.data.length);
        output.write(this.data);
    }

    @Override
    public int getSerializedSize() {
        return super.getSerializedSize() + 4 + this.data.length;
    }
}

