/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty.handler;

import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.utils.IncreasingBitSet;
import org.apache.hadoop.conf.Configuration;

public class WorkerRequestReservedMap {
    private final ConcurrentMap<Integer, IncreasingBitSet> workerRequestReservedMap;

    public WorkerRequestReservedMap(Configuration conf) {
        this.workerRequestReservedMap = new MapMaker().concurrencyLevel(conf.getInt("giraph.msgNumFlushThreads", 32)).makeMap();
    }

    public boolean reserveRequest(Integer workerId, long requestId) {
        IncreasingBitSet requestSet = this.getRequestSet(workerId);
        return requestSet.add(requestId);
    }

    private IncreasingBitSet getRequestSet(Integer workerId) {
        IncreasingBitSet previous;
        IncreasingBitSet requestSet = (IncreasingBitSet)this.workerRequestReservedMap.get(workerId);
        if (requestSet == null && (previous = this.workerRequestReservedMap.putIfAbsent(workerId, requestSet = new IncreasingBitSet())) != null) {
            requestSet = previous;
        }
        return requestSet;
    }
}

