/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty.handler;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import org.apache.giraph.comm.netty.NettyServer;
import org.apache.giraph.comm.netty.SaslNettyServer;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.SaslCompleteRequest;
import org.apache.giraph.comm.requests.SaslTokenMessageRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.log4j.Logger;

public class SaslServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(SaslServerHandler.class);
    private static volatile boolean ALREADY_CLOSED_FIRST_REQUEST = false;
    private final boolean closeFirstRequest;
    private JobTokenSecretManager secretManager;

    public SaslServerHandler(Configuration conf) throws IOException {
        SaslNettyServer.init((Configuration)conf);
        this.setupSecretManager(conf);
        this.closeFirstRequest = GiraphConstants.NETTY_SIMULATE_FIRST_REQUEST_CLOSED.get(conf);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("messageReceived: Got " + msg.getClass()));
        }
        WritableRequest writableRequest = (WritableRequest)msg;
        if (this.closeFirstRequest && !ALREADY_CLOSED_FIRST_REQUEST) {
            LOG.info((Object)("messageReceived: Simulating closing channel on first request " + writableRequest.getRequestId() + " from " + writableRequest.getClientId()));
            SaslServerHandler.setAlreadyClosedFirstRequest();
            ctx.close();
            return;
        }
        if (writableRequest.getType() == RequestType.SASL_TOKEN_MESSAGE_REQUEST) {
            SaslNettyServer saslNettyServer = (SaslNettyServer)((Object)ctx.attr(NettyServer.CHANNEL_SASL_NETTY_SERVERS).get());
            if (saslNettyServer == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No saslNettyServer for " + ctx.channel() + " yet; creating now, with secret manager: " + this.secretManager));
                }
                try {
                    saslNettyServer = new SaslNettyServer(this.secretManager, SaslRpcServer.AuthMethod.SIMPLE);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                ctx.attr(NettyServer.CHANNEL_SASL_NETTY_SERVERS).set((Object)saslNettyServer);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found existing saslNettyServer on server:" + ctx.channel().localAddress() + " for client " + ctx.channel().remoteAddress()));
            }
            ((SaslTokenMessageRequest)writableRequest).processToken(saslNettyServer);
            ctx.write((Object)writableRequest);
            if (saslNettyServer.isComplete()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("SASL authentication is complete for client with username: " + saslNettyServer.getUserName()));
                }
                SaslCompleteRequest saslComplete = new SaslCompleteRequest();
                ctx.write((Object)saslComplete);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Removing SaslServerHandler from pipeline since SASL authentication is complete.");
                }
                ctx.pipeline().remove((ChannelHandler)this);
            }
            ctx.flush();
            return;
        }
        LOG.warn((Object)("Sending upstream an unexpected non-SASL message :  " + writableRequest));
        ctx.fireChannelRead(msg);
    }

    private static void setAlreadyClosedFirstRequest() {
        ALREADY_CLOSED_FIRST_REQUEST = true;
    }

    private void setupSecretManager(Configuration conf) throws IOException {
        this.secretManager = new JobTokenSecretManager();
        String localJobTokenFile = System.getenv().get("HADOOP_TOKEN_FILE_LOCATION");
        if (localJobTokenFile == null) {
            throw new IOException("Could not find job credentials: environment variable: HADOOP_TOKEN_FILE_LOCATION was not defined.");
        }
        JobConf jobConf = new JobConf(conf);
        Credentials credentials = TokenCache.loadTokens((String)localJobTokenFile, (JobConf)jobConf);
        Collection collection = credentials.getAllTokens();
        for (Token token : collection) {
            TokenIdentifier tokenIdentifier = this.decodeIdentifier((Token<? extends TokenIdentifier>)token, JobTokenIdentifier.class);
            if (!(tokenIdentifier instanceof JobTokenIdentifier)) continue;
            Token theToken = token;
            JobTokenIdentifier jobTokenIdentifier = (JobTokenIdentifier)tokenIdentifier;
            this.secretManager.addTokenForJob(jobTokenIdentifier.getJobId().toString(), theToken);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("loaded JobToken credentials: " + credentials + " from " + "localJobTokenFile: " + localJobTokenFile));
        }
    }

    private TokenIdentifier decodeIdentifier(Token<? extends TokenIdentifier> token, Class<? extends TokenIdentifier> cls) throws IOException {
        TokenIdentifier tokenIdentifier = (TokenIdentifier)ReflectionUtils.newInstance(cls, null);
        ByteArrayInputStream buf = new ByteArrayInputStream(token.getIdentifier());
        DataInputStream in = new DataInputStream(buf);
        tokenIdentifier.readFields((DataInput)in);
        in.close();
        return tokenIdentifier;
    }

    public static class Factory {
        public SaslServerHandler newHandler(Configuration conf) throws IOException {
            return new SaslServerHandler(conf);
        }
    }
}

