/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.FixedLengthFrameDecoder;
import io.netty.util.ReferenceCountUtil;
import java.io.DataInput;
import java.io.IOException;
import org.apache.giraph.comm.netty.NettyClient;
import org.apache.giraph.comm.netty.SaslNettyClient;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.SaslCompleteRequest;
import org.apache.giraph.comm.requests.SaslTokenMessageRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.log4j.Logger;

public class SaslClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(SaslClientHandler.class);
    private final Configuration conf;

    public SaslClientHandler(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        byte[] responseToServer;
        WritableRequest decodedMessage = this.decode(ctx, msg);
        SaslNettyClient saslNettyClient = (SaslNettyClient)ctx.attr(NettyClient.SASL).get();
        if (saslNettyClient == null) {
            throw new Exception("handleUpstream: saslNettyClient was unexpectedly null for channel: " + ctx.channel());
        }
        if (decodedMessage.getClass() == SaslCompleteRequest.class) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"handleUpstream: Server has sent us the SaslComplete message. Allowing normal work to proceed.");
            }
            Object object = saslNettyClient.getAuthenticated();
            synchronized (object) {
                saslNettyClient.getAuthenticated().notify();
            }
            if (!saslNettyClient.isComplete()) {
                LOG.error((Object)"handleUpstream: Server returned a Sasl-complete message, but as far as we can tell, we are not authenticated yet.");
                throw new Exception("handleUpstream: Server returned a Sasl-complete message, but as far as we can tell, we are not authenticated yet.");
            }
            ctx.pipeline().remove((ChannelHandler)this);
            ctx.pipeline().replace("length-field-based-frame-decoder", "fixed-length-frame-decoder", (ChannelHandler)new FixedLengthFrameDecoder(13));
            return;
        }
        SaslTokenMessageRequest serverToken = (SaslTokenMessageRequest)decodedMessage;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("handleUpstream: Responding to server's token of length: " + serverToken.getSaslToken().length));
        }
        if ((responseToServer = saslNettyClient.saslResponse(serverToken)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"handleUpstream: Response to server is null: authentication should now be complete.");
            }
            if (!saslNettyClient.isComplete()) {
                LOG.warn((Object)"handleUpstream: Generated a null response, but authentication is not complete.");
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("handleUpstream: Response to server token has length:" + responseToServer.length));
        }
        SaslTokenMessageRequest saslResponse = new SaslTokenMessageRequest(responseToServer);
        ctx.channel().writeAndFlush((Object)saslResponse);
    }

    protected WritableRequest decode(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            throw new IllegalStateException("decode: Got illegal message " + msg);
        }
        ByteBuf buf = (ByteBuf)msg;
        ByteBufInputStream inputStream = new ByteBufInputStream(buf);
        byte enumValue = inputStream.readByte();
        RequestType type = RequestType.values()[enumValue];
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decode: Got a response of type " + (Object)((Object)type) + " from server:" + ctx.channel().remoteAddress()));
        }
        Class<? extends WritableRequest> writableRequestClass = type.getRequestClass();
        WritableRequest serverResponse = (WritableRequest)ReflectionUtils.newInstance(writableRequestClass, (Configuration)this.conf);
        try {
            serverResponse.readFields((DataInput)inputStream);
        }
        catch (IOException e) {
            LOG.error((Object)("decode: Exception when trying to read server response: " + e));
        }
        ReferenceCountUtil.release((Object)buf);
        return serverResponse;
    }
}

