/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.io.DataOutput;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.log4j.Logger;

public class ResponseEncoder
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(ResponseEncoder.class);

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("write(" + ctx + "," + msg));
        }
        if (!(msg instanceof WritableRequest)) {
            throw new IllegalArgumentException("encode: cannot encode message of type " + msg.getClass() + " since it is not an instance of an implementation of " + " WritableRequest.");
        }
        WritableRequest writableRequest = (WritableRequest)msg;
        ByteBuf buf = ctx.alloc().buffer(10);
        ByteBufOutputStream output = new ByteBufOutputStream(buf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("encode: Encoding a message of type " + msg.getClass()));
        }
        output.writeInt(0);
        output.writeByte(writableRequest.getType().ordinal());
        writableRequest.write((DataOutput)output);
        output.flush();
        output.close();
        buf.setInt(0, buf.writerIndex() - 4);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("encode: Encoding a message of type " + msg.getClass()));
        }
        ctx.write((Object)buf, promise);
        if (writableRequest.getType() == RequestType.SASL_COMPLETE_REQUEST) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("encode: Removing RequestEncoder handler: no longer needed, since client: " + ctx.channel().remoteAddress() + " has " + "completed authenticating."));
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }
        ctx.write((Object)buf, promise);
    }
}

