/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.ConcurrentMap;
import org.apache.giraph.comm.netty.handler.ClientRequestId;
import org.apache.giraph.comm.netty.handler.RequestInfo;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class ResponseClientHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(ResponseClientHandler.class);
    private static volatile boolean ALREADY_DROPPED_FIRST_RESPONSE = false;
    private final boolean dropFirstResponse;
    private final ConcurrentMap<ClientRequestId, RequestInfo> workerIdOutstandingRequestMap;

    public ResponseClientHandler(ConcurrentMap<ClientRequestId, RequestInfo> workerIdOutstandingRequestMap, Configuration conf) {
        this.workerIdOutstandingRequestMap = workerIdOutstandingRequestMap;
        this.dropFirstResponse = GiraphConstants.NETTY_SIMULATE_FIRST_RESPONSE_FAILED.get(conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            throw new IllegalStateException("messageReceived: Got a non-ByteBuf message " + msg);
        }
        ByteBuf buf = (ByteBuf)msg;
        int senderId = -1;
        long requestId = -1L;
        int response = -1;
        try {
            senderId = buf.readInt();
            requestId = buf.readLong();
            response = buf.readByte();
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalStateException("channelRead: Got IndexOutOfBoundsException ", e);
        }
        ReferenceCountUtil.release((Object)buf);
        if (this.dropFirstResponse && !ALREADY_DROPPED_FIRST_RESPONSE) {
            LOG.info((Object)("messageReceived: Simulating dropped response " + response + " for request " + requestId));
            ResponseClientHandler.setAlreadyDroppedFirstResponse();
            ConcurrentMap<ClientRequestId, RequestInfo> e = this.workerIdOutstandingRequestMap;
            synchronized (e) {
                this.workerIdOutstandingRequestMap.notifyAll();
            }
            return;
        }
        if (response == 1) {
            LOG.info((Object)("messageReceived: Already completed request (taskId = " + senderId + ", requestId = " + requestId + ")"));
        } else if (response != 0) {
            throw new IllegalStateException("messageReceived: Got illegal response " + response);
        }
        RequestInfo requestInfo = (RequestInfo)this.workerIdOutstandingRequestMap.remove(new ClientRequestId(senderId, requestId));
        if (requestInfo == null) {
            LOG.info((Object)("messageReceived: Already received response for (taskId = " + senderId + ", requestId = " + requestId + ")"));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("messageReceived: Completed (taskId = " + senderId + ")" + requestInfo + ".  Waiting on " + this.workerIdOutstandingRequestMap.size() + " requests"));
        }
        ConcurrentMap<ClientRequestId, RequestInfo> concurrentMap = this.workerIdOutstandingRequestMap;
        synchronized (concurrentMap) {
            this.workerIdOutstandingRequestMap.notifyAll();
        }
    }

    private static void setAlreadyDroppedFirstResponse() {
        ALREADY_DROPPED_FIRST_RESPONSE = true;
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("channelClosed: Closed the channel on " + ctx.channel().remoteAddress()));
        }
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.warn((Object)("exceptionCaught: Channel failed with remote address " + ctx.channel().remoteAddress()), cause);
    }
}

