/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.giraph.comm.netty.handler.WorkerRequestReservedMap;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.TaskInfo;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;
import org.apache.giraph.time.Times;
import org.apache.log4j.Logger;

public abstract class RequestServerHandler<R>
extends ChannelInboundHandlerAdapter {
    public static final int RESPONSE_BYTES = 13;
    private static Time TIME = SystemTime.get();
    private static final Logger LOG = Logger.getLogger(RequestServerHandler.class);
    private static volatile boolean ALREADY_CLOSED_FIRST_REQUEST = false;
    private final boolean closeFirstRequest;
    private final WorkerRequestReservedMap workerRequestReservedMap;
    private final TaskInfo myTaskInfo;
    private long startProcessingNanoseconds = -1L;
    private final Thread.UncaughtExceptionHandler exceptionHandler;

    public RequestServerHandler(WorkerRequestReservedMap workerRequestReservedMap, ImmutableClassesGiraphConfiguration conf, TaskInfo myTaskInfo, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.workerRequestReservedMap = workerRequestReservedMap;
        this.closeFirstRequest = GiraphConstants.NETTY_SIMULATE_FIRST_REQUEST_CLOSED.get(conf);
        this.myTaskInfo = myTaskInfo;
        this.exceptionHandler = exceptionHandler;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("messageReceived: Got " + msg.getClass()));
        }
        WritableRequest request = (WritableRequest)msg;
        if (this.closeFirstRequest && !ALREADY_CLOSED_FIRST_REQUEST) {
            LOG.info((Object)("messageReceived: Simulating closing channel on first request " + request.getRequestId() + " from " + request.getClientId()));
            RequestServerHandler.setAlreadyClosedFirstRequest();
            ctx.close();
            return;
        }
        int alreadyDone = 1;
        if (this.workerRequestReservedMap.reserveRequest(request.getClientId(), request.getRequestId())) {
            if (LOG.isDebugEnabled()) {
                this.startProcessingNanoseconds = TIME.getNanoseconds();
            }
            this.processRequest(request);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("messageReceived: Processing client " + request.getClientId() + ", " + "requestId " + request.getRequestId() + ", " + (Object)((Object)request.getType()) + " took " + Times.getNanosSince(TIME, this.startProcessingNanoseconds) + " ns"));
            }
            alreadyDone = 0;
        } else {
            LOG.info((Object)("messageReceived: Request id " + request.getRequestId() + " from client " + request.getClientId() + " was already processed, " + "not processing again."));
        }
        ByteBuf buffer = ctx.alloc().buffer(13);
        buffer.writeInt(this.myTaskInfo.getTaskId());
        buffer.writeLong(request.getRequestId());
        buffer.writeByte(alreadyDone);
        ctx.write((Object)buffer);
    }

    private static void setAlreadyClosedFirstRequest() {
        ALREADY_CLOSED_FIRST_REQUEST = true;
    }

    public abstract void processRequest(R var1);

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("channelActive: Connected the channel on " + ctx.channel().remoteAddress()));
        }
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("channelInactive: Closed the channel on " + ctx.channel().remoteAddress()));
        }
        ctx.fireChannelInactive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.exceptionHandler.uncaughtException(Thread.currentThread(), cause);
    }

    public static interface Factory {
        public RequestServerHandler newHandler(WorkerRequestReservedMap var1, ImmutableClassesGiraphConfiguration var2, TaskInfo var3, Thread.UncaughtExceptionHandler var4);
    }
}

