/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty.handler;

import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.util.Date;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;

public class RequestInfo {
    private static final Time TIME = SystemTime.get();
    private final InetSocketAddress destinationAddress;
    private final long startedNanos;
    private final WritableRequest request;
    private volatile ChannelFuture writeFuture;

    public RequestInfo(InetSocketAddress destinationAddress, WritableRequest request) {
        this.destinationAddress = destinationAddress;
        this.request = request;
        this.startedNanos = TIME.getNanoseconds();
    }

    public InetSocketAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    public long getStartedMsecs() {
        return this.startedNanos / 1000000L;
    }

    public long getElapsedNanos() {
        return TIME.getNanoseconds() - this.startedNanos;
    }

    public long getElapsedMsecs() {
        return this.getElapsedNanos() / 1000000L;
    }

    public WritableRequest getRequest() {
        return this.request;
    }

    public void setWriteFuture(ChannelFuture writeFuture) {
        this.writeFuture = writeFuture;
    }

    public ChannelFuture getWriteFuture() {
        return this.writeFuture;
    }

    public String toString() {
        return "(reqId=" + this.request.getRequestId() + ",destAddr=" + this.destinationAddress.getHostName() + ":" + this.destinationAddress.getPort() + ",elapsedNanos=" + this.getElapsedNanos() + ",started=" + new Date(this.getStartedMsecs()) + (this.writeFuture == null ? ")" : ",writeDone=" + this.writeFuture.isDone() + ",writeSuccess=" + this.writeFuture.isSuccess() + ")");
    }
}

