/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import java.io.DataOutput;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;
import org.apache.giraph.time.Times;
import org.apache.log4j.Logger;

public class RequestEncoder
extends ChannelOutboundHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(RequestEncoder.class);
    private static final Time TIME = SystemTime.get();
    private final int bufferStartingSize;
    private long startEncodingNanoseconds = -1L;

    public RequestEncoder(GiraphConfiguration conf) {
        this.bufferStartingSize = GiraphConstants.NETTY_REQUEST_ENCODER_BUFFER_SIZE.get(conf);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        WritableRequest request;
        int requestSize;
        if (!(msg instanceof WritableRequest)) {
            throw new IllegalArgumentException("encode: Got a message of type " + msg.getClass());
        }
        if (LOG.isDebugEnabled()) {
            this.startEncodingNanoseconds = TIME.getNanoseconds();
        }
        ByteBuf buf = (requestSize = (request = (WritableRequest)msg).getSerializedSize()) == -1 ? ctx.alloc().buffer(this.bufferStartingSize) : ctx.alloc().buffer(requestSize += 5);
        ByteBufOutputStream output = new ByteBufOutputStream(buf);
        output.writeInt(0);
        output.writeByte(request.getType().ordinal());
        try {
            request.write((DataOutput)output);
        }
        catch (IndexOutOfBoundsException e) {
            LOG.error((Object)("write: Most likely the size of request was not properly specified (this buffer is too small) - see getSerializedSize() in " + request.getType().getRequestClass()));
            throw new IllegalStateException(e);
        }
        output.flush();
        output.close();
        buf.setInt(0, buf.writerIndex() - 4);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("write: Client " + request.getClientId() + ", " + "requestId " + request.getRequestId() + ", size = " + buf.readableBytes() + ", " + (Object)((Object)request.getType()) + " took " + Times.getNanosSince(TIME, this.startEncodingNanoseconds) + " ns"));
        }
        ctx.write((Object)buf, promise);
    }
}

