/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import org.apache.giraph.comm.netty.InboundByteCounter;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.time.SystemTime;
import org.apache.giraph.time.Time;
import org.apache.giraph.time.Times;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.giraph.utils.RequestUtils;
import org.apache.log4j.Logger;

public class RequestDecoder
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(RequestDecoder.class);
    private static final Time TIME = SystemTime.get();
    private final ImmutableClassesGiraphConfiguration conf;
    private final InboundByteCounter byteCounter;
    private long startDecodingNanoseconds = -1L;

    public RequestDecoder(ImmutableClassesGiraphConfiguration conf, InboundByteCounter byteCounter) {
        this.conf = conf;
        this.byteCounter = byteCounter;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof ByteBuf)) {
            throw new IllegalStateException("decode: Got illegal message " + msg);
        }
        String metrics = this.byteCounter.getMetricsWindow(30000);
        if (metrics != null && LOG.isInfoEnabled()) {
            LOG.info((Object)("decode: Server window metrics " + metrics));
        }
        if (LOG.isDebugEnabled()) {
            this.startDecodingNanoseconds = TIME.getNanoseconds();
        }
        ByteBuf buf = (ByteBuf)msg;
        byte enumValue = buf.readByte();
        RequestType type = RequestType.values()[enumValue];
        Class<? extends WritableRequest> requestClass = type.getRequestClass();
        WritableRequest request = ReflectionUtils.newInstance(requestClass, this.conf);
        request = RequestUtils.decodeWritableRequest(buf, request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("decode: Client " + request.getClientId() + ", requestId " + request.getRequestId() + ", " + (Object)((Object)request.getType()) + ", with size " + buf.writerIndex() + " took " + Times.getNanosSince(TIME, this.startDecodingNanoseconds) + " ns"));
        }
        ReferenceCountUtil.release((Object)buf);
        ctx.fireChannelRead((Object)request);
    }
}

