/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.giraph.comm.netty.NettyServer;
import org.apache.giraph.comm.netty.SaslNettyServer;
import org.apache.log4j.Logger;

public class AuthorizeServerHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(AuthorizeServerHandler.class);

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        SaslNettyServer saslNettyServer;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("messageReceived: Got " + msg.getClass()));
        }
        if ((saslNettyServer = (SaslNettyServer)((Object)ctx.attr(NettyServer.CHANNEL_SASL_NETTY_SERVERS).get())) == null) {
            LOG.warn((Object)("messageReceived: This client is *NOT* authorized to perform this action since there's no saslNettyServer to authenticate the client: refusing to perform requested action: " + msg));
            return;
        }
        if (!saslNettyServer.isComplete()) {
            LOG.warn((Object)("messageReceived: This client is *NOT* authorized to perform this action because SASL authentication did not complete: refusing to perform requested action: " + msg));
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("messageReceived: authenticated client: " + saslNettyServer.getUserName() + " is authorized to do request " + "on server."));
        }
        ctx.fireChannelRead(msg);
    }
}

