/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty.handler;

import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class AddressRequestIdGenerator {
    private final ConcurrentMap<InetSocketAddress, AtomicLong> addressRequestGeneratorMap = Maps.newConcurrentMap();

    public Long getNextRequestId(InetSocketAddress address) {
        AtomicLong oldRequestGenerator;
        AtomicLong requestGenerator = (AtomicLong)this.addressRequestGeneratorMap.get(address);
        if (requestGenerator == null && (oldRequestGenerator = this.addressRequestGeneratorMap.putIfAbsent(address, requestGenerator = new AtomicLong(0L))) != null) {
            requestGenerator = oldRequestGenerator;
        }
        return requestGenerator.getAndIncrement();
    }
}

