/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import org.apache.commons.net.util.Base64;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.StandbyException;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.security.SaslPropertiesResolver;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.log4j.Logger;

public class SaslNettyServer
extends SaslRpcServer {
    public static final Logger LOG = Logger.getLogger(SaslNettyServer.class);
    private SaslServer saslServer;

    public SaslNettyServer(JobTokenSecretManager secretManager) throws IOException {
        this(secretManager, SaslRpcServer.AuthMethod.SIMPLE);
    }

    public SaslNettyServer(JobTokenSecretManager secretManager, SaslRpcServer.AuthMethod authMethod) throws IOException {
        super(authMethod);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("SaslNettyServer: Secret manager is: " + secretManager + " with authmethod " + authMethod));
        }
        try {
            secretManager.checkAvailableForRead();
        }
        catch (StandbyException e) {
            LOG.error((Object)("SaslNettyServer: Could not read secret manager: " + (Object)((Object)e)));
        }
        try {
            SaslDigestCallbackHandler ch = new SaslDigestCallbackHandler(secretManager);
            SaslPropertiesResolver saslPropsResolver = SaslPropertiesResolver.getInstance((Configuration)new Configuration());
            this.saslServer = Sasl.createSaslServer(SaslRpcServer.AuthMethod.DIGEST.getMechanismName(), null, "default", saslPropsResolver.getDefaultProperties(), ch);
        }
        catch (SaslException e) {
            LOG.error((Object)("SaslNettyServer: Could not create SaslServer: " + e));
        }
    }

    public boolean isComplete() {
        return this.saslServer.isComplete();
    }

    public String getUserName() {
        return this.saslServer.getAuthorizationID();
    }

    public byte[] response(byte[] token) {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("response: Responding to input token of length: " + token.length));
            }
            byte[] retval = this.saslServer.evaluateResponse(token);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("response: Response token length: " + retval.length));
            }
            return retval;
        }
        catch (SaslException e) {
            LOG.error((Object)("response: Failed to evaluate client token of length: " + token.length + " : " + e));
            return null;
        }
    }

    static String encodeIdentifier(byte[] identifier) {
        return new String(Base64.encodeBase64((byte[])identifier), Charset.defaultCharset());
    }

    static char[] encodePassword(byte[] password) {
        return new String(Base64.encodeBase64((byte[])password), Charset.defaultCharset()).toCharArray();
    }

    @InterfaceStability.Evolving
    public static class SaslDigestCallbackHandler
    implements CallbackHandler {
        private JobTokenSecretManager secretManager;

        public SaslDigestCallbackHandler(JobTokenSecretManager secretManager) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SaslDigestCallback: Creating SaslDigestCallback handler with secret manager: " + secretManager));
            }
            this.secretManager = secretManager;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) continue;
                throw new UnsupportedCallbackException(callback, "handle: Unrecognized SASL DIGEST-MD5 Callback");
            }
            if (pc != null) {
                JobTokenIdentifier tokenIdentifier = (JobTokenIdentifier)SaslRpcServer.getIdentifier((String)nc.getDefaultName(), (SecretManager)this.secretManager);
                char[] password = SaslNettyServer.encodePassword(this.secretManager.retrievePassword(tokenIdentifier));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("handle: SASL server DIGEST-MD5 callback: setting password for client: " + tokenIdentifier.getUser()));
                }
                pc.setPassword(password);
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    if (LOG.isDebugEnabled()) {
                        String username = ((JobTokenIdentifier)SaslRpcServer.getIdentifier((String)authzid, (SecretManager)this.secretManager)).getUser().getUserName();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("handle: SASL server DIGEST-MD5 callback: setting canonicalized client ID: " + username));
                        }
                    }
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }
}

