/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.giraph.comm.netty.SaslNettyServer;
import org.apache.giraph.comm.requests.SaslTokenMessageRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SaslPropertiesResolver;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.log4j.Logger;

public class SaslNettyClient {
    public static final Logger LOG = Logger.getLogger(SaslNettyClient.class);
    private Object authenticated = new Object();
    private SaslClient saslClient;

    public SaslNettyClient() {
        try {
            Token<JobTokenIdentifier> token = this.createJobToken(new Configuration());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("SaslNettyClient: Creating SASL " + SaslRpcServer.AuthMethod.DIGEST.getMechanismName() + " client to authenticate to service at " + token.getService()));
            }
            SaslPropertiesResolver saslPropsResolver = SaslPropertiesResolver.getInstance((Configuration)new Configuration());
            this.saslClient = Sasl.createSaslClient(new String[]{SaslRpcServer.AuthMethod.DIGEST.getMechanismName()}, null, null, "default", saslPropsResolver.getDefaultProperties(), new SaslClientCallbackHandler(token));
        }
        catch (IOException e) {
            LOG.error((Object)"SaslNettyClient: Could not obtain job token for Netty Client to use to authenticate with a Netty Server.");
            this.saslClient = null;
        }
    }

    public Object getAuthenticated() {
        return this.authenticated;
    }

    private Token<JobTokenIdentifier> createJobToken(Configuration conf) throws IOException {
        String localJobTokenFile = System.getenv().get("HADOOP_TOKEN_FILE_LOCATION");
        if (localJobTokenFile != null) {
            JobConf jobConf = new JobConf(conf);
            Credentials credentials = TokenCache.loadTokens((String)localJobTokenFile, (JobConf)jobConf);
            return TokenCache.getJobToken((Credentials)credentials);
        }
        throw new IOException("createJobToken: Cannot obtain authentication credentials for job: file: 'HADOOP_TOKEN_FILE_LOCATION' not found");
    }

    public SaslTokenMessageRequest firstToken() throws IOException {
        byte[] saslToken = new byte[]{};
        if (this.saslClient.hasInitialResponse()) {
            saslToken = this.saslClient.evaluateChallenge(saslToken);
        }
        SaslTokenMessageRequest saslTokenMessage = new SaslTokenMessageRequest();
        saslTokenMessage.setSaslToken(saslToken);
        return saslTokenMessage;
    }

    public boolean isComplete() {
        return this.saslClient.isComplete();
    }

    public byte[] saslResponse(SaslTokenMessageRequest saslTokenMessage) {
        try {
            byte[] retval = this.saslClient.evaluateChallenge(saslTokenMessage.getSaslToken());
            return retval;
        }
        catch (SaslException e) {
            LOG.error((Object)"saslResponse: Failed to respond to SASL server's token:", (Throwable)e);
            return null;
        }
    }

    private static class SaslClientCallbackHandler
    implements CallbackHandler {
        private final String userName;
        private final char[] userPassword;

        public SaslClientCallbackHandler(Token<? extends TokenIdentifier> token) {
            this.userName = SaslNettyServer.encodeIdentifier(token.getIdentifier());
            this.userPassword = SaslNettyServer.encodePassword(token.getPassword());
        }

        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            TextInputCallback rc = null;
            for (Callback callback : callbacks) {
                if (callback instanceof RealmChoiceCallback) continue;
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) {
                    rc = (RealmCallback)callback;
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "handle: Unrecognized SASL client callback");
            }
            if (nc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("handle: SASL client callback: setting username: " + this.userName));
                }
                nc.setName(this.userName);
            }
            if (pc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"handle: SASL client callback: setting userPassword");
                }
                pc.setPassword(this.userPassword);
            }
            if (rc != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("handle: SASL client callback: setting realm: " + rc.getDefaultText()));
                }
                rc.setText(rc.getDefaultText());
            }
        }
    }
}

