/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import org.apache.giraph.comm.netty.ByteCounter;
import org.apache.giraph.comm.netty.ByteCounterDelegate;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.metrics.ResetSuperstepMetricsObserver;
import org.apache.giraph.metrics.SuperstepMetricsRegistry;
import org.apache.log4j.Logger;

@ChannelHandler.Sharable
public class OutboundByteCounter
extends ChannelOutboundHandlerAdapter
implements ByteCounter,
ResetSuperstepMetricsObserver {
    private static final Logger LOG = Logger.getLogger(OutboundByteCounter.class);
    private final ByteCounterDelegate delegate = new ByteCounterDelegate(false);

    public OutboundByteCounter() {
        GiraphMetrics.get().addSuperstepResetObserver(this);
    }

    public long getBytesSent() {
        return this.delegate.getBytesProcessed();
    }

    public double getMbytesPerSecSent() {
        return this.delegate.getMbytesPerSecProcessed();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            int sentBytes = this.delegate.byteBookkeeper(buf);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("write: " + ctx.channel().toString() + " buffer size = " + sentBytes + ", total bytes = " + this.getBytesSent()));
            }
        }
        ctx.writeAndFlush(msg, promise);
    }

    @Override
    public void newSuperstep(SuperstepMetricsRegistry superstepMetrics) {
        this.delegate.newSuperstep(superstepMetrics);
    }

    @Override
    public void resetAll() {
        this.delegate.resetAll();
    }

    @Override
    public String getMetrics() {
        return this.delegate.getMetrics();
    }

    @Override
    public String getMetricsWindow(int minMsecsWindow) {
        return this.delegate.getMetricsWindow(minMsecsWindow);
    }
}

