/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Map;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.WorkerServer;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.messages.MessageStoreFactory;
import org.apache.giraph.comm.netty.NettyServer;
import org.apache.giraph.comm.netty.handler.WorkerRequestServerHandler;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexMutations;
import org.apache.giraph.graph.VertexResolver;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class NettyWorkerServer<I extends WritableComparable, V extends Writable, E extends Writable>
implements WorkerServer<I, V, E> {
    private static final Logger LOG = Logger.getLogger(NettyWorkerServer.class);
    private final ImmutableClassesGiraphConfiguration<I, V, E> conf;
    private final CentralizedServiceWorker<I, V, E> service;
    private final NettyServer nettyServer;
    private final ServerData<I, V, E> serverData;
    private final Mapper.Context context;

    public NettyWorkerServer(ImmutableClassesGiraphConfiguration<I, V, E> conf, CentralizedServiceWorker<I, V, E> service, Mapper.Context context, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.conf = conf;
        this.service = service;
        this.context = context;
        this.serverData = new ServerData<I, V, E>(service, conf, this.createMessageStoreFactory(), context);
        this.nettyServer = new NettyServer(conf, new WorkerRequestServerHandler.Factory<I, V, E>(this.serverData), service.getWorkerInfo(), (Progressable)context, exceptionHandler);
        this.nettyServer.start();
    }

    private MessageStoreFactory<I, Writable, MessageStore<I, Writable>> createMessageStoreFactory() {
        Class<MessageStoreFactory> messageStoreFactoryClass = GiraphConstants.MESSAGE_STORE_FACTORY_CLASS.get(this.conf);
        MessageStoreFactory messageStoreFactoryInstance = ReflectionUtils.newInstance(messageStoreFactoryClass);
        messageStoreFactoryInstance.initialize(this.service, this.conf);
        return messageStoreFactoryInstance;
    }

    @Override
    public InetSocketAddress getMyAddress() {
        return this.nettyServer.getMyAddress();
    }

    @Override
    public void prepareSuperstep() {
        this.serverData.prepareSuperstep();
        this.resolveMutations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveMutations() {
        Partition<WritableComparable, V, E> partition;
        HashMultimap resolveVertexIndices = HashMultimap.create((int)this.service.getPartitionStore().getNumPartitions(), (int)100);
        for (Map.Entry<I, VertexMutations<I, V, E>> e : this.serverData.getVertexMutations().entrySet()) {
            WritableComparable vertexId = (WritableComparable)e.getKey();
            Integer partitionId = this.service.getPartitionId(vertexId);
            if (resolveVertexIndices.put((Object)partitionId, (Object)vertexId)) continue;
            throw new IllegalStateException("resolveMutations: Already has missing vertex on this worker for " + vertexId);
        }
        for (Integer partitionId : this.service.getPartitionStore().getPartitionIds()) {
            Iterable<I> destinations = this.serverData.getCurrentMessageStore().getPartitionDestinationVertices(partitionId);
            if (Iterables.isEmpty(destinations)) continue;
            partition = this.service.getPartitionStore().getOrCreatePartition(partitionId);
            for (WritableComparable vertexId : destinations) {
                if (partition.getVertex(vertexId) != null || resolveVertexIndices.put((Object)partitionId, (Object)vertexId)) continue;
                throw new IllegalStateException("resolveMutations: Already has missing vertex on this worker for " + vertexId);
            }
            this.service.getPartitionStore().putPartition(partition);
        }
        VertexResolver<WritableComparable, V, E> vertexResolver = this.conf.createVertexResolver();
        for (Map.Entry e : resolveVertexIndices.asMap().entrySet()) {
            partition = this.service.getPartitionStore().getOrCreatePartition((Integer)e.getKey());
            for (WritableComparable vertexIndex : (Collection)e.getValue()) {
                Vertex<WritableComparable, V, E> originalVertex = partition.getVertex(vertexIndex);
                VertexMutations<I, V, E> mutations = null;
                VertexMutations<I, V, E> vertexMutations = this.serverData.getVertexMutations().get(vertexIndex);
                if (vertexMutations != null) {
                    VertexMutations<I, V, E> vertexMutations2 = vertexMutations;
                    synchronized (vertexMutations2) {
                        mutations = vertexMutations.copy();
                    }
                    this.serverData.getVertexMutations().remove(vertexIndex);
                }
                Vertex<WritableComparable, V, E> vertex = vertexResolver.resolve(vertexIndex, originalVertex, mutations, this.serverData.getCurrentMessageStore().hasMessagesForVertex(vertexIndex));
                this.context.progress();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("resolveMutations: Resolved vertex index " + vertexIndex + " with original vertex " + originalVertex + ", returned vertex " + vertex + " on superstep " + this.service.getSuperstep() + " with mutations " + mutations));
                }
                if (vertex != null) {
                    partition.putVertex(vertex);
                    continue;
                }
                if (originalVertex == null) continue;
                partition.removeVertex(originalVertex.getId());
            }
            this.service.getPartitionStore().putPartition(partition);
        }
        if (!this.serverData.getVertexMutations().isEmpty()) {
            throw new IllegalStateException("resolveMutations: Illegally still has " + this.serverData.getVertexMutations().size() + " mutations left.");
        }
    }

    @Override
    public ServerData<I, V, E> getServerData() {
        return this.serverData;
    }

    @Override
    public void close() {
        this.nettyServer.stop();
    }
}

