/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.util.PercentGauge;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.SendEdgeCache;
import org.apache.giraph.comm.SendMessageCache;
import org.apache.giraph.comm.SendMutationsCache;
import org.apache.giraph.comm.SendOneMessageToManyCache;
import org.apache.giraph.comm.SendPartitionCache;
import org.apache.giraph.comm.ServerData;
import org.apache.giraph.comm.WorkerClient;
import org.apache.giraph.comm.WorkerClientRequestProcessor;
import org.apache.giraph.comm.messages.MessageStore;
import org.apache.giraph.comm.requests.SendPartitionCurrentMessagesRequest;
import org.apache.giraph.comm.requests.SendPartitionMutationsRequest;
import org.apache.giraph.comm.requests.SendVertexRequest;
import org.apache.giraph.comm.requests.SendWorkerEdgesRequest;
import org.apache.giraph.comm.requests.SendWorkerVerticesRequest;
import org.apache.giraph.comm.requests.WorkerRequest;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.graph.VertexMutations;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.metrics.SuperstepMetricsRegistry;
import org.apache.giraph.partition.Partition;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.utils.ByteArrayVertexIdMessages;
import org.apache.giraph.utils.ExtendedDataOutput;
import org.apache.giraph.utils.PairList;
import org.apache.giraph.utils.VertexIdEdges;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;

public class NettyWorkerClientRequestProcessor<I extends WritableComparable, V extends Writable, E extends Writable>
implements WorkerClientRequestProcessor<I, V, E> {
    private static final Logger LOG = Logger.getLogger(NettyWorkerClientRequestProcessor.class);
    private final SendPartitionCache<I, V, E> sendPartitionCache;
    private final SendMessageCache<I, Writable> sendMessageCache;
    private final SendEdgeCache<I, E> sendEdgeCache;
    private final SendMutationsCache<I, V, E> sendMutationsCache = new SendMutationsCache();
    private final WorkerClient<I, V, E> workerClient;
    private long totalMsgsSentInSuperstep = 0L;
    private final int maxMessagesSizePerWorker;
    private final int maxVerticesSizePerWorker;
    private final int maxEdgesSizePerWorker;
    private final int maxMutationsPerPartition;
    private final ImmutableClassesGiraphConfiguration<I, V, E> configuration;
    private final CentralizedServiceWorker<I, V, E> serviceWorker;
    private final ServerData<I, V, E> serverData;
    private final Counter localRequests;
    private final Counter remoteRequests;

    public NettyWorkerClientRequestProcessor(Mapper.Context context, ImmutableClassesGiraphConfiguration<I, V, E> conf, CentralizedServiceWorker<I, V, E> serviceWorker) {
        this.workerClient = serviceWorker.getWorkerClient();
        this.configuration = conf;
        this.sendPartitionCache = new SendPartitionCache<I, V, E>(conf, serviceWorker);
        this.sendEdgeCache = new SendEdgeCache(conf, serviceWorker);
        this.maxMessagesSizePerWorker = GiraphConfiguration.MAX_MSG_REQUEST_SIZE.get(conf);
        this.maxVerticesSizePerWorker = GiraphConfiguration.MAX_VERTEX_REQUEST_SIZE.get(conf);
        this.sendMessageCache = this.configuration.useOneMessageToManyIdsEncoding() ? new SendOneMessageToManyCache<I, Writable>(conf, serviceWorker, this, this.maxMessagesSizePerWorker) : new SendMessageCache(conf, serviceWorker, this, this.maxMessagesSizePerWorker);
        this.maxEdgesSizePerWorker = GiraphConfiguration.MAX_EDGE_REQUEST_SIZE.get(conf);
        this.maxMutationsPerPartition = GiraphConfiguration.MAX_MUTATIONS_PER_REQUEST.get(conf);
        this.serviceWorker = serviceWorker;
        this.serverData = serviceWorker.getServerData();
        SuperstepMetricsRegistry smr = GiraphMetrics.get().perSuperstep();
        this.localRequests = smr.getCounter("local-requests");
        this.remoteRequests = smr.getCounter("remote-requests");
        NettyWorkerClientRequestProcessor.setupGauges(smr, this.localRequests, this.remoteRequests);
    }

    @Override
    public void sendMessageRequest(I destVertexId, Writable message) {
        this.sendMessageCache.sendMessageRequest(destVertexId, message);
    }

    @Override
    public void sendMessageToAllRequest(Vertex<I, V, E> vertex, Writable message) {
        this.sendMessageCache.sendMessageToAllRequest(vertex, message);
    }

    @Override
    public void sendMessageToAllRequest(Iterator<I> vertexIdIterator, Writable message) {
        this.sendMessageCache.sendMessageToAllRequest(vertexIdIterator, message);
    }

    @Override
    public void sendPartitionRequest(WorkerInfo workerInfo, Partition<I, V, E> partition) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("sendVertexRequest: Sending to " + workerInfo + ", with partition " + partition));
        }
        SendVertexRequest<I, V, E> vertexRequest = new SendVertexRequest<I, V, E>(partition);
        this.doRequest(workerInfo, vertexRequest);
        if (this.serviceWorker.getSuperstep() != -1L) {
            this.sendPartitionMessages(workerInfo, partition);
        }
    }

    private void sendPartitionMessages(WorkerInfo workerInfo, Partition<I, V, E> partition) {
        int partitionId = partition.getId();
        MessageStore messageStore = this.serverData.getCurrentMessageStore();
        ByteArrayVertexIdMessages vertexIdMessages = new ByteArrayVertexIdMessages(this.configuration.getOutgoingMessageValueFactory());
        vertexIdMessages.setConf((ImmutableClassesGiraphConfiguration)this.configuration);
        vertexIdMessages.initialize();
        for (WritableComparable vertexId : messageStore.getPartitionDestinationVertices(partitionId)) {
            try {
                Iterable messages = messageStore.getVertexMessages(vertexId);
                for (Writable message : messages) {
                    vertexIdMessages.add(vertexId, message);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("sendVertexRequest: Got IOException ", e);
            }
            if (vertexIdMessages.getSize() <= this.maxMessagesSizePerWorker) continue;
            SendPartitionCurrentMessagesRequest messagesRequest = new SendPartitionCurrentMessagesRequest(partitionId, vertexIdMessages);
            this.doRequest(workerInfo, messagesRequest);
            vertexIdMessages = new ByteArrayVertexIdMessages(this.configuration.getOutgoingMessageValueFactory());
            vertexIdMessages.setConf((ImmutableClassesGiraphConfiguration)this.configuration);
            vertexIdMessages.initialize();
        }
        if (!vertexIdMessages.isEmpty()) {
            SendPartitionCurrentMessagesRequest messagesRequest = new SendPartitionCurrentMessagesRequest(partitionId, vertexIdMessages);
            this.doRequest(workerInfo, messagesRequest);
        }
    }

    @Override
    public boolean sendVertexRequest(PartitionOwner partitionOwner, Vertex<I, V, E> vertex) {
        int workerMessageSize = this.sendPartitionCache.addVertex(partitionOwner, vertex);
        if (workerMessageSize >= this.maxVerticesSizePerWorker) {
            PairList<Integer, ExtendedDataOutput> workerPartitionVertices = this.sendPartitionCache.removeWorkerData(partitionOwner.getWorkerInfo());
            SendWorkerVerticesRequest<I, V, E> writableRequest = new SendWorkerVerticesRequest<I, V, E>(this.configuration, workerPartitionVertices);
            this.doRequest(partitionOwner.getWorkerInfo(), writableRequest);
            return true;
        }
        return false;
    }

    @Override
    public void addEdgeRequest(I vertexIndex, Edge<I, E> edge) throws IOException {
        PartitionOwner partitionOwner = this.serviceWorker.getVertexPartitionOwner(vertexIndex);
        int partitionId = partitionOwner.getPartitionId();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("addEdgeRequest: Sending edge " + edge + " for index " + vertexIndex + " with partition " + partitionId));
        }
        int partitionMutationCount = this.sendMutationsCache.addEdgeMutation(partitionId, vertexIndex, edge);
        this.sendMutationsRequestIfFull(partitionId, partitionOwner, partitionMutationCount);
    }

    @Override
    public boolean sendEdgeRequest(I sourceVertexId, Edge<I, E> edge) throws IOException {
        int workerEdgesSize;
        PartitionOwner owner = this.serviceWorker.getVertexPartitionOwner(sourceVertexId);
        WorkerInfo workerInfo = owner.getWorkerInfo();
        int partitionId = owner.getPartitionId();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("sendEdgeRequest: Send bytes (" + edge.toString() + ") to " + sourceVertexId + " on worker " + workerInfo));
        }
        if ((workerEdgesSize = this.sendEdgeCache.addEdge(workerInfo, partitionId, sourceVertexId, edge)) >= this.maxEdgesSizePerWorker) {
            PairList<Integer, VertexIdEdges<I, E>> workerEdges = this.sendEdgeCache.removeWorkerEdges(workerInfo);
            SendWorkerEdgesRequest<I, E> writableRequest = new SendWorkerEdgesRequest<I, E>(workerEdges);
            this.doRequest(workerInfo, writableRequest);
            return true;
        }
        return false;
    }

    private void sendMutationsRequestIfFull(int partitionId, PartitionOwner partitionOwner, int partitionMutationCount) {
        if (partitionMutationCount >= this.maxMutationsPerPartition) {
            Map<I, VertexMutations<I, V, E>> partitionMutations = this.sendMutationsCache.removePartitionMutations(partitionId);
            SendPartitionMutationsRequest<I, V, E> writableRequest = new SendPartitionMutationsRequest<I, V, E>(partitionId, partitionMutations);
            this.doRequest(partitionOwner.getWorkerInfo(), writableRequest);
        }
    }

    @Override
    public void removeEdgesRequest(I vertexIndex, I destinationVertexIndex) throws IOException {
        PartitionOwner partitionOwner = this.serviceWorker.getVertexPartitionOwner(vertexIndex);
        int partitionId = partitionOwner.getPartitionId();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("removeEdgesRequest: Removing edge " + destinationVertexIndex + " for index " + vertexIndex + " with partition " + partitionId));
        }
        int partitionMutationCount = this.sendMutationsCache.removeEdgeMutation(partitionId, vertexIndex, destinationVertexIndex);
        this.sendMutationsRequestIfFull(partitionId, partitionOwner, partitionMutationCount);
    }

    @Override
    public void addVertexRequest(Vertex<I, V, E> vertex) throws IOException {
        PartitionOwner partitionOwner = this.serviceWorker.getVertexPartitionOwner(vertex.getId());
        int partitionId = partitionOwner.getPartitionId();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("addVertexRequest: Sending vertex " + vertex + " to partition " + partitionId));
        }
        int partitionMutationCount = this.sendMutationsCache.addVertexMutation(partitionId, vertex);
        this.sendMutationsRequestIfFull(partitionId, partitionOwner, partitionMutationCount);
    }

    @Override
    public void removeVertexRequest(I vertexIndex) throws IOException {
        PartitionOwner partitionOwner = this.serviceWorker.getVertexPartitionOwner(vertexIndex);
        int partitionId = partitionOwner.getPartitionId();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("removeVertexRequest: Removing vertex index " + vertexIndex + " from partition " + partitionId));
        }
        int partitionMutationCount = this.sendMutationsCache.removeVertexMutation(partitionId, vertexIndex);
        this.sendMutationsRequestIfFull(partitionId, partitionOwner, partitionMutationCount);
    }

    @Override
    public void flush() throws IOException {
        this.sendMessageCache.flush();
        PairList remainingVertexCache = this.sendPartitionCache.removeAllData();
        PairList.Iterator vertexIterator = remainingVertexCache.getIterator();
        while (vertexIterator.hasNext()) {
            vertexIterator.next();
            SendWorkerVerticesRequest<I, V, E> writableRequest = new SendWorkerVerticesRequest<I, V, E>(this.configuration, (PairList)vertexIterator.getCurrentSecond());
            this.doRequest((WorkerInfo)vertexIterator.getCurrentFirst(), writableRequest);
        }
        PairList<WorkerInfo, PairList<Integer, VertexIdEdges<I, E>>> remainingEdgeCache = this.sendEdgeCache.removeAllEdges();
        PairList.Iterator edgeIterator = remainingEdgeCache.getIterator();
        while (edgeIterator.hasNext()) {
            edgeIterator.next();
            SendWorkerEdgesRequest writableRequest = new SendWorkerEdgesRequest((PairList)edgeIterator.getCurrentSecond());
            this.doRequest((WorkerInfo)edgeIterator.getCurrentFirst(), writableRequest);
        }
        Map<Integer, Map<I, VertexMutations<I, V, E>>> remainingMutationsCache = this.sendMutationsCache.removeAllPartitionMutations();
        for (Map.Entry<Integer, Map<I, VertexMutations<I, V, E>>> entry : remainingMutationsCache.entrySet()) {
            SendPartitionMutationsRequest<I, V, E> writableRequest = new SendPartitionMutationsRequest<I, V, E>(entry.getKey(), entry.getValue());
            PartitionOwner partitionOwner = this.serviceWorker.getVertexPartitionOwner((WritableComparable)entry.getValue().keySet().iterator().next());
            this.doRequest(partitionOwner.getWorkerInfo(), writableRequest);
        }
    }

    @Override
    public long resetMessageCount() {
        return this.sendMessageCache.resetMessageCount();
    }

    @Override
    public long resetMessageBytesCount() {
        return this.sendMessageCache.resetMessageBytesCount();
    }

    public void doRequest(WorkerInfo workerInfo, WritableRequest writableRequest) {
        if (this.serviceWorker.getWorkerInfo().getTaskId() == workerInfo.getTaskId()) {
            ((WorkerRequest)((Object)writableRequest)).doRequest(this.serverData);
            this.localRequests.inc();
        } else {
            this.workerClient.sendWritableRequest(workerInfo.getTaskId(), writableRequest);
            this.remoteRequests.inc();
        }
    }

    private static void setupGauges(SuperstepMetricsRegistry smr, final Counter localRequests, final Counter remoteRequests) {
        final Gauge<Long> totalRequests = smr.getGauge("total-requests", new Gauge<Long>(){

            public Long value() {
                return localRequests.count() + remoteRequests.count();
            }
        });
        smr.getGauge("percent-local-requests", new PercentGauge(){

            protected double getNumerator() {
                return localRequests.count();
            }

            protected double getDenominator() {
                return ((Long)totalRequests.value()).longValue();
            }
        });
    }
}

