/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yammer.metrics.core.Counter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.WorkerClient;
import org.apache.giraph.comm.netty.NettyClient;
import org.apache.giraph.comm.requests.RequestType;
import org.apache.giraph.comm.requests.WritableRequest;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.metrics.GiraphMetrics;
import org.apache.giraph.metrics.ResetSuperstepMetricsObserver;
import org.apache.giraph.metrics.SuperstepMetricsRegistry;
import org.apache.giraph.partition.PartitionOwner;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.log4j.Logger;

public class NettyWorkerClient<I extends WritableComparable, V extends Writable, E extends Writable>
implements WorkerClient<I, V, E>,
ResetSuperstepMetricsObserver {
    private static final Logger LOG = Logger.getLogger(NettyWorkerClient.class);
    private final ImmutableClassesGiraphConfiguration<I, V, E> conf;
    private final NettyClient nettyClient;
    private final CentralizedServiceWorker<I, V, E> service;
    private final Map<RequestType, Counter> superstepRequestCounters;

    public NettyWorkerClient(Mapper.Context context, ImmutableClassesGiraphConfiguration<I, V, E> configuration, CentralizedServiceWorker<I, V, E> service, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.nettyClient = new NettyClient(context, configuration, service.getWorkerInfo(), exceptionHandler);
        this.conf = configuration;
        this.service = service;
        this.superstepRequestCounters = Maps.newHashMap();
        GiraphMetrics.get().addSuperstepResetObserver(this);
    }

    @Override
    public void newSuperstep(SuperstepMetricsRegistry metrics) {
        this.superstepRequestCounters.clear();
        this.superstepRequestCounters.put(RequestType.SEND_WORKER_VERTICES_REQUEST, metrics.getCounter("send-vertex-requests"));
        this.superstepRequestCounters.put(RequestType.SEND_WORKER_MESSAGES_REQUEST, metrics.getCounter("send-worker-messages-requests"));
        this.superstepRequestCounters.put(RequestType.SEND_PARTITION_CURRENT_MESSAGES_REQUEST, metrics.getCounter("send-partition-current-messages-requests"));
        this.superstepRequestCounters.put(RequestType.SEND_PARTITION_MUTATIONS_REQUEST, metrics.getCounter("send-partition-mutations-requests"));
        this.superstepRequestCounters.put(RequestType.SEND_WORKER_AGGREGATORS_REQUEST, metrics.getCounter("send-worker-aggregators-requests"));
        this.superstepRequestCounters.put(RequestType.SEND_AGGREGATORS_TO_MASTER_REQUEST, metrics.getCounter("send-aggregators-to-master-requests"));
        this.superstepRequestCounters.put(RequestType.SEND_AGGREGATORS_TO_OWNER_REQUEST, metrics.getCounter("send-aggregators-to-owner-requests"));
        this.superstepRequestCounters.put(RequestType.SEND_AGGREGATORS_TO_WORKER_REQUEST, metrics.getCounter("send-aggregators-to-worker-requests"));
    }

    public CentralizedServiceWorker<I, V, E> getService() {
        return this.service;
    }

    @Override
    public void openConnections() {
        ArrayList addresses = Lists.newArrayListWithCapacity((int)this.service.getWorkerInfoList().size());
        for (WorkerInfo info : this.service.getWorkerInfoList()) {
            if (this.service.getWorkerInfo().getTaskId() == info.getTaskId()) continue;
            addresses.add(info);
        }
        addresses.add(this.service.getMasterInfo());
        this.nettyClient.connectAllAddresses(addresses);
    }

    @Override
    public PartitionOwner getVertexPartitionOwner(I vertexId) {
        return this.service.getVertexPartitionOwner(vertexId);
    }

    @Override
    public void sendWritableRequest(Integer destTaskId, WritableRequest request) {
        Counter counter = this.superstepRequestCounters.get((Object)request.getType());
        if (counter != null) {
            counter.inc();
        }
        this.nettyClient.sendWritableRequest(destTaskId, request);
    }

    @Override
    public void waitAllRequests() {
        this.nettyClient.waitAllRequests();
    }

    @Override
    public void closeConnections() throws IOException {
        this.nettyClient.stop();
    }

    @Override
    public void setup(boolean authenticate) {
        this.openConnections();
        if (authenticate) {
            this.authenticate();
        }
    }

    @Override
    public void authenticate() {
        this.nettyClient.authenticate();
    }
}

