/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import java.io.IOException;
import org.apache.giraph.bsp.CentralizedServiceWorker;
import org.apache.giraph.comm.GlobalCommType;
import org.apache.giraph.comm.WorkerClient;
import org.apache.giraph.comm.aggregators.AggregatorUtils;
import org.apache.giraph.comm.aggregators.SendGlobalCommCache;
import org.apache.giraph.comm.aggregators.WorkerAggregatorRequestProcessor;
import org.apache.giraph.comm.requests.SendAggregatorsToWorkerRequest;
import org.apache.giraph.comm.requests.SendReducedToMasterRequest;
import org.apache.giraph.comm.requests.SendWorkerAggregatorsRequest;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Progressable;

public class NettyWorkerAggregatorRequestProcessor
implements WorkerAggregatorRequestProcessor {
    private final Progressable progressable;
    private final WorkerClient<?, ?, ?> workerClient;
    private final CentralizedServiceWorker<?, ?, ?> serviceWorker;
    private final SendGlobalCommCache sendReducedValuesCache = new SendGlobalCommCache(false);
    private final int maxBytesPerAggregatorRequest;

    public NettyWorkerAggregatorRequestProcessor(Progressable progressable, ImmutableClassesGiraphConfiguration<?, ?, ?> configuration, CentralizedServiceWorker<?, ?, ?> serviceWorker) {
        this.serviceWorker = serviceWorker;
        this.workerClient = serviceWorker.getWorkerClient();
        this.progressable = progressable;
        this.maxBytesPerAggregatorRequest = configuration.getInt("giraph.maxBytesPerAggregatorRequest", 0x100000);
    }

    @Override
    public boolean sendReducedValue(String name, Writable reducedValue) throws IOException {
        WorkerInfo owner = AggregatorUtils.getOwner(name, this.serviceWorker.getWorkerInfoList());
        if (this.isThisWorker(owner)) {
            return false;
        }
        int currentSize = this.sendReducedValuesCache.addValue(owner.getTaskId(), name, GlobalCommType.REDUCED_VALUE, reducedValue);
        if (currentSize >= this.maxBytesPerAggregatorRequest) {
            this.flushAggregatorsToWorker(owner);
        }
        return true;
    }

    @Override
    public void flush() throws IOException {
        for (WorkerInfo workerInfo : this.serviceWorker.getWorkerInfoList()) {
            if (this.isThisWorker(workerInfo)) continue;
            this.sendReducedValuesCache.addSpecialCount(workerInfo.getTaskId());
            this.flushAggregatorsToWorker(workerInfo);
            this.progressable.progress();
        }
        this.sendReducedValuesCache.reset();
    }

    private void flushAggregatorsToWorker(WorkerInfo worker) {
        byte[] data = this.sendReducedValuesCache.removeSerialized(worker.getTaskId());
        this.workerClient.sendWritableRequest(worker.getTaskId(), new SendWorkerAggregatorsRequest(data, this.serviceWorker.getWorkerInfo().getTaskId()));
    }

    @Override
    public void sendReducedValuesToMaster(byte[] data) throws IOException {
        this.workerClient.sendWritableRequest(this.serviceWorker.getMasterInfo().getTaskId(), new SendReducedToMasterRequest(data));
    }

    @Override
    public void distributeReducedValues(Iterable<byte[]> aggregatorDataList) throws IOException {
        for (byte[] aggregatorData : aggregatorDataList) {
            for (WorkerInfo worker : this.serviceWorker.getWorkerInfoList()) {
                if (!this.isThisWorker(worker)) {
                    SendAggregatorsToWorkerRequest request = new SendAggregatorsToWorkerRequest(aggregatorData, this.serviceWorker.getWorkerInfo().getTaskId());
                    this.workerClient.sendWritableRequest(worker.getTaskId(), request);
                }
                this.progressable.progress();
            }
        }
    }

    private boolean isThisWorker(WorkerInfo workerInfo) {
        return this.serviceWorker.getWorkerInfo().getTaskId() == workerInfo.getTaskId();
    }
}

