/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.AdaptiveRecvByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.apache.giraph.comm.netty.InboundByteCounter;
import org.apache.giraph.comm.netty.OutboundByteCounter;
import org.apache.giraph.comm.netty.SaslNettyServer;
import org.apache.giraph.comm.netty.handler.AuthorizeServerHandler;
import org.apache.giraph.comm.netty.handler.RequestDecoder;
import org.apache.giraph.comm.netty.handler.RequestServerHandler;
import org.apache.giraph.comm.netty.handler.ResponseEncoder;
import org.apache.giraph.comm.netty.handler.SaslServerHandler;
import org.apache.giraph.comm.netty.handler.WorkerRequestReservedMap;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.TaskInfo;
import org.apache.giraph.utils.PipelineUtils;
import org.apache.giraph.utils.ProgressableUtils;
import org.apache.giraph.utils.ThreadUtils;
import org.apache.hadoop.util.Progressable;
import org.apache.log4j.Logger;

public class NettyServer {
    public static final int MAXIMUM_THREAD_POOL_SIZE_DEFAULT = 32;
    public static final AttributeKey<SaslNettyServer> CHANNEL_SASL_NETTY_SERVERS = AttributeKey.valueOf((String)"channelSaslServers");
    private static final Logger LOG = Logger.getLogger(NettyServer.class);
    private final ImmutableClassesGiraphConfiguration conf;
    private final Progressable progressable;
    private final ChannelGroup accepted = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
    private final String localHostname;
    private InetSocketAddress myAddress;
    private TaskInfo myTaskInfo;
    private final int maxPoolSize;
    private final int tcpBacklog;
    private final RequestServerHandler.Factory requestServerHandlerFactory;
    private SaslServerHandler.Factory saslServerHandlerFactory;
    private ServerBootstrap bootstrap;
    private final InboundByteCounter inByteCounter = new InboundByteCounter();
    private final OutboundByteCounter outByteCounter = new OutboundByteCounter();
    private final int sendBufferSize;
    private final int receiveBufferSize;
    private final EventLoopGroup bossGroup;
    private final EventLoopGroup workerGroup;
    private final WorkerRequestReservedMap workerRequestReservedMap;
    private final boolean useExecutionGroup;
    private final EventExecutorGroup executionGroup;
    private final String handlerToUseExecutionGroup;
    private final Thread.UncaughtExceptionHandler exceptionHandler;

    public NettyServer(ImmutableClassesGiraphConfiguration conf, RequestServerHandler.Factory requestServerHandlerFactory, TaskInfo myTaskInfo, Progressable progressable, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.conf = conf;
        this.progressable = progressable;
        this.requestServerHandlerFactory = requestServerHandlerFactory;
        this.saslServerHandlerFactory = new SaslServerHandler.Factory();
        this.myTaskInfo = myTaskInfo;
        this.exceptionHandler = exceptionHandler;
        this.sendBufferSize = GiraphConstants.SERVER_SEND_BUFFER_SIZE.get(conf);
        this.receiveBufferSize = GiraphConstants.SERVER_RECEIVE_BUFFER_SIZE.get(conf);
        this.workerRequestReservedMap = new WorkerRequestReservedMap(conf);
        this.maxPoolSize = GiraphConstants.NETTY_SERVER_THREADS.get(conf);
        this.bossGroup = new NioEventLoopGroup(4, ThreadUtils.createThreadFactory("netty-server-boss-%d", exceptionHandler));
        this.workerGroup = new NioEventLoopGroup(this.maxPoolSize, ThreadUtils.createThreadFactory("netty-server-worker-%d", exceptionHandler));
        try {
            this.localHostname = conf.getLocalHostname();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("NettyServer: unable to get hostname");
        }
        this.tcpBacklog = conf.getInt(GiraphConstants.TCP_BACKLOG.getKey(), conf.getInt("giraph.maxWorkers", GiraphConstants.TCP_BACKLOG.getDefaultValue()));
        this.handlerToUseExecutionGroup = GiraphConstants.NETTY_SERVER_EXECUTION_AFTER_HANDLER.get(conf);
        this.useExecutionGroup = GiraphConstants.NETTY_SERVER_USE_EXECUTION_HANDLER.get(conf);
        if (this.useExecutionGroup) {
            int executionThreads = conf.getNettyServerExecutionThreads();
            this.executionGroup = new DefaultEventExecutorGroup(executionThreads, ThreadUtils.createThreadFactory("netty-server-exec-%d", exceptionHandler));
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("NettyServer: Using execution group with " + executionThreads + " threads for " + this.handlerToUseExecutionGroup + "."));
            }
        } else {
            this.executionGroup = null;
        }
    }

    public NettyServer(ImmutableClassesGiraphConfiguration conf, RequestServerHandler.Factory requestServerHandlerFactory, TaskInfo myTaskInfo, Progressable progressable, SaslServerHandler.Factory saslServerHandlerFactory, Thread.UncaughtExceptionHandler exceptionHandler) {
        this(conf, requestServerHandlerFactory, myTaskInfo, progressable, exceptionHandler);
        this.saslServerHandlerFactory = saslServerHandlerFactory;
    }

    public void start() {
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)this.tcpBacklog)).option(ChannelOption.ALLOCATOR, (Object)this.conf.getNettyAllocator())).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_SNDBUF, (Object)this.sendBufferSize).childOption(ChannelOption.SO_RCVBUF, (Object)this.receiveBufferSize).childOption(ChannelOption.ALLOCATOR, (Object)this.conf.getNettyAllocator()).childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new AdaptiveRecvByteBufAllocator(this.receiveBufferSize / 4, this.receiveBufferSize, this.receiveBufferSize));
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                if (NettyServer.this.conf.authenticate()) {
                    LOG.info((Object)"start: Will use Netty pipeline with authentication and authorization of clients.");
                    PipelineUtils.addLastWithExecutorCheck("serverInboundByteCounter", (ChannelHandler)NettyServer.this.inByteCounter, NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    if (NettyServer.this.conf.doCompression()) {
                        PipelineUtils.addLastWithExecutorCheck("compressionDecoder", (ChannelHandler)NettyServer.this.conf.getNettyCompressionDecoder(), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    }
                    PipelineUtils.addLastWithExecutorCheck("serverOutboundByteCounter", (ChannelHandler)NettyServer.this.outByteCounter, NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    if (NettyServer.this.conf.doCompression()) {
                        PipelineUtils.addLastWithExecutorCheck("compressionEncoder", (ChannelHandler)NettyServer.this.conf.getNettyCompressionEncoder(), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    }
                    PipelineUtils.addLastWithExecutorCheck("requestFrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x40000000, 0, 4, 0, 4), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("requestDecoder", (ChannelHandler)new RequestDecoder(NettyServer.this.conf, NettyServer.this.inByteCounter), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("saslServerHandler", (ChannelHandler)NettyServer.this.saslServerHandlerFactory.newHandler(NettyServer.this.conf), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("authorizeServerHandler", (ChannelHandler)new AuthorizeServerHandler(), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("requestServerHandler", (ChannelHandler)NettyServer.this.requestServerHandlerFactory.newHandler(NettyServer.this.workerRequestReservedMap, NettyServer.this.conf, NettyServer.this.myTaskInfo, NettyServer.this.exceptionHandler), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("responseEncoder", (ChannelHandler)new ResponseEncoder(), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                } else {
                    LOG.info((Object)"start: Using Netty without authentication.");
                    ch.pipeline().addLast("connectedChannels", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                        public void channelActive(ChannelHandlerContext ctx) throws Exception {
                            NettyServer.this.accepted.add((Object)ctx.channel());
                            ctx.fireChannelActive();
                        }
                    });
                    PipelineUtils.addLastWithExecutorCheck("serverInboundByteCounter", (ChannelHandler)NettyServer.this.inByteCounter, NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    if (NettyServer.this.conf.doCompression()) {
                        PipelineUtils.addLastWithExecutorCheck("compressionDecoder", (ChannelHandler)NettyServer.this.conf.getNettyCompressionDecoder(), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    }
                    PipelineUtils.addLastWithExecutorCheck("serverOutboundByteCounter", (ChannelHandler)NettyServer.this.outByteCounter, NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    if (NettyServer.this.conf.doCompression()) {
                        PipelineUtils.addLastWithExecutorCheck("compressionEncoder", (ChannelHandler)NettyServer.this.conf.getNettyCompressionEncoder(), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    }
                    PipelineUtils.addLastWithExecutorCheck("requestFrameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x40000000, 0, 4, 0, 4), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("requestDecoder", (ChannelHandler)new RequestDecoder(NettyServer.this.conf, NettyServer.this.inByteCounter), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                    PipelineUtils.addLastWithExecutorCheck("requestServerHandler", (ChannelHandler)NettyServer.this.requestServerHandlerFactory.newHandler(NettyServer.this.workerRequestReservedMap, NettyServer.this.conf, NettyServer.this.myTaskInfo, NettyServer.this.exceptionHandler), NettyServer.this.handlerToUseExecutionGroup, NettyServer.this.executionGroup, (Channel)ch);
                }
            }
        });
        int taskId = this.conf.getTaskPartition();
        int numTasks = this.conf.getInt("mapred.map.tasks", 1);
        int numServers = this.conf.getInt("giraph.maxWorkers", numTasks) + 1;
        int portIncrementConstant = (int)Math.pow(10.0, Math.ceil(Math.log10(numServers)));
        int bindPort = GiraphConstants.IPC_INITIAL_PORT.get(this.conf) + taskId;
        int bindAttempts = 0;
        int maxIpcPortBindAttempts = GiraphConstants.MAX_IPC_PORT_BIND_ATTEMPTS.get(this.conf);
        boolean failFirstPortBindingAttempt = GiraphConstants.FAIL_FIRST_IPC_PORT_BIND_ATTEMPT.get(this.conf);
        while (bindAttempts < maxIpcPortBindAttempts) {
            this.myAddress = new InetSocketAddress(this.localHostname, bindPort);
            if (failFirstPortBindingAttempt && bindAttempts == 0) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("start: Intentionally fail first binding attempt as giraph.failFirstIpcPortBindAttempt is true, port " + bindPort));
                }
                ++bindAttempts;
                bindPort += portIncrementConstant;
                continue;
            }
            try {
                ChannelFuture f = this.bootstrap.bind((SocketAddress)this.myAddress).sync();
                this.accepted.add((Object)f.channel());
                break;
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (Exception e) {
                LOG.warn((Object)("start: Likely failed to bind on attempt " + bindAttempts + " to port " + bindPort), e.getCause());
                ++bindAttempts;
                bindPort += portIncrementConstant;
            }
        }
        if (bindAttempts == maxIpcPortBindAttempts || this.myAddress == null) {
            throw new IllegalStateException("start: Failed to start NettyServer with " + bindAttempts + " attempts");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("start: Started server communication server: " + this.myAddress + " with up to " + this.maxPoolSize + " threads on bind attempt " + bindAttempts + " with sendBufferSize = " + this.sendBufferSize + " receiveBufferSize = " + this.receiveBufferSize));
        }
    }

    public void stop() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"stop: Halting netty server");
        }
        ProgressableUtils.awaitChannelGroupFuture(this.accepted.close(), this.progressable);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"stop: Start releasing resources");
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        ProgressableUtils.awaitTerminationFuture((EventExecutorGroup)this.bossGroup, this.progressable);
        ProgressableUtils.awaitTerminationFuture((EventExecutorGroup)this.workerGroup, this.progressable);
        if (this.useExecutionGroup) {
            this.executionGroup.shutdownGracefully();
            ProgressableUtils.awaitTerminationFuture(this.executionGroup, this.progressable);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"stop: Netty server halted");
        }
    }

    public InetSocketAddress getMyAddress() {
        return this.myAddress;
    }
}

