/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.comm.netty;

import java.io.IOException;
import org.apache.giraph.bsp.CentralizedServiceMaster;
import org.apache.giraph.comm.GlobalCommType;
import org.apache.giraph.comm.MasterClient;
import org.apache.giraph.comm.aggregators.AggregatorUtils;
import org.apache.giraph.comm.aggregators.SendGlobalCommCache;
import org.apache.giraph.comm.netty.NettyClient;
import org.apache.giraph.comm.requests.SendAggregatorsToOwnerRequest;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.worker.WorkerInfo;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Progressable;

public class NettyMasterClient
implements MasterClient {
    private final NettyClient nettyClient;
    private final CentralizedServiceMaster<?, ?, ?> service;
    private final SendGlobalCommCache sendGlobalCommCache = new SendGlobalCommCache(true);
    private final int maxBytesPerAggregatorRequest;
    private final Progressable progressable;

    public NettyMasterClient(Mapper.Context context, ImmutableClassesGiraphConfiguration configuration, CentralizedServiceMaster<?, ?, ?> service, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.nettyClient = new NettyClient(context, configuration, service.getMasterInfo(), exceptionHandler);
        this.service = service;
        this.progressable = context;
        this.maxBytesPerAggregatorRequest = configuration.getInt("giraph.maxBytesPerAggregatorRequest", 0x100000);
    }

    @Override
    public void openConnections() {
        this.nettyClient.connectAllAddresses(this.service.getWorkerInfoList());
    }

    @Override
    public void sendToOwner(String name, GlobalCommType sendType, Writable object) throws IOException {
        WorkerInfo owner = AggregatorUtils.getOwner(name, this.service.getWorkerInfoList());
        int currentSize = this.sendGlobalCommCache.addValue(owner.getTaskId(), name, sendType, object);
        if (currentSize >= this.maxBytesPerAggregatorRequest) {
            this.flushAggregatorsToWorker(owner);
        }
    }

    @Override
    public void finishSendingValues() throws IOException {
        for (WorkerInfo worker : this.service.getWorkerInfoList()) {
            this.sendGlobalCommCache.addSpecialCount(worker.getTaskId());
            this.flushAggregatorsToWorker(worker);
            this.progressable.progress();
        }
        this.sendGlobalCommCache.reset();
    }

    private void flushAggregatorsToWorker(WorkerInfo worker) {
        byte[] data = this.sendGlobalCommCache.removeSerialized(worker.getTaskId());
        this.nettyClient.sendWritableRequest(worker.getTaskId(), new SendAggregatorsToOwnerRequest(data, this.service.getMasterInfo().getTaskId()));
    }

    @Override
    public void flush() {
        this.nettyClient.waitAllRequests();
    }

    @Override
    public void closeConnections() {
        this.nettyClient.stop();
    }
}

